/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.model;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.IndexConfiguration;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class IndexDocumentOptions {
    private File document;
    private InputStream documentInputStream;
    private String mediaType;
    private Map<String, String> metadata;
    private JsonObject convertDocumentConfig;
    private IndexConfiguration indexConfiguration;
    private Boolean dryRun;

    public File document() {
        return this.document;
    }

    public InputStream getDocumentInputStream() {
        return this.documentInputStream;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public JsonObject convertDocumentConfig() {
        return this.convertDocumentConfig;
    }

    public IndexConfiguration indexConfiguration() {
        return this.indexConfiguration;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    private IndexDocumentOptions(Builder builder) {
        this.document = builder.document;
        this.documentInputStream = builder.documentInputStream;
        this.mediaType = builder.mediaType;
        this.metadata = builder.metadata;
        this.convertDocumentConfig = builder.conversionConfiguration;
        this.indexConfiguration = builder.indexConfiguration;
        this.dryRun = builder.dryRun;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private File document;
        private InputStream documentInputStream;
        private String mediaType;
        private Map<String, String> metadata;
        private JsonObject conversionConfiguration;
        private IndexConfiguration indexConfiguration;
        private boolean dryRun;

        private Builder(IndexDocumentOptions options) {
            this.document = options.document;
            this.documentInputStream = options.documentInputStream;
            this.mediaType = options.mediaType;
            this.metadata = options.metadata;
            this.conversionConfiguration = options.convertDocumentConfig;
            this.indexConfiguration = options.indexConfiguration;
            this.dryRun = options.dryRun;
        }

        public Builder() {
        }

        public IndexDocumentOptions build() {
            return new IndexDocumentOptions(this);
        }

        public Builder document(InputStream document, String mediaType) {
            this.documentInputStream = document;
            this.mediaType = mediaType;
            return this;
        }

        public Builder document(File document) {
            this.document = document;
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder convertDocumentConfig(JsonObject convertDocumentConfig) {
            this.conversionConfiguration = convertDocumentConfig;
            return this;
        }

        public Builder indexConfiguration(IndexConfiguration indexConfiguration) {
            this.indexConfiguration = indexConfiguration;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }
    }
}

