/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import java.util.HashMap;
import java.util.Map;

public class MessageRequest
extends GenericModel {
    private Map<String, Object> context;
    private Map<String, Object> input;
    @SerializedName(value="alternate_intents")
    private Boolean alternateIntents;

    private MessageRequest(Builder options) {
        this.context = options.context;
        this.input = options.input;
        this.alternateIntents = options.alternateIntents;
    }

    public Map<String, Object> context() {
        return this.context;
    }

    public Boolean alternateIntents() {
        return this.alternateIntents;
    }

    public Map<String, Object> input() {
        return this.input;
    }

    public String inputText() {
        return this.input != null && this.input.get("text") != null ? this.input.get("text").toString() : null;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private static final String TEXT = "text";
        private Map<String, Object> context;
        private Map<String, Object> input;
        private Boolean alternateIntents;

        public Builder() {
        }

        private Builder(MessageRequest messageRequest) {
            this.input = new HashMap<String, Object>(messageRequest.input);
            this.context = new HashMap<String, Object>(messageRequest.context);
            this.alternateIntents = messageRequest.alternateIntents;
        }

        public MessageRequest build() {
            return new MessageRequest(this);
        }

        public Builder context(Map<String, Object> context) {
            this.context = context != null ? new HashMap(context) : context;
            return this;
        }

        public Builder alternateIntents(Boolean alternateIntents) {
            this.alternateIntents = alternateIntents;
            return this;
        }

        public Builder input(Map<String, Object> input) {
            this.input = input != null ? new HashMap<String, Object>(input) : null;
            return this;
        }

        public Builder inputText(String text) {
            if (this.input == null) {
                this.input = new HashMap<String, Object>();
            }
            this.input.put(TEXT, text);
            return this;
        }
    }
}

