/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AlchemyEndPoints {
    private static final String FILE_PATH = "/alchemy_endpoints.json";
    private static final Logger LOG = Logger.getLogger(AlchemyEndPoints.class.getName());
    private static Map<String, Map<String, String>> OPERATIONS;

    private AlchemyEndPoints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEndPointsFromJsonFile() {
        LOG.log(Level.FINE, "Parsing End Points JSON file ");
        OPERATIONS = new HashMap<String, Map<String, String>>();
        JsonParser parser = new JsonParser();
        Reader fileReader = null;
        try {
            InputStream is = AlchemyEndPoints.class.getResourceAsStream(FILE_PATH);
            if (null != is) {
                fileReader = new InputStreamReader(is);
            }
            JsonElement obj = parser.parse(fileReader);
            JsonObject jsonObject = (JsonObject)obj;
            for (AlchemyAPI object : AlchemyAPI.values()) {
                JsonObject elt;
                if (jsonObject.get(object.name()) == null || !(elt = jsonObject.get(object.name()).getAsJsonObject()).isJsonObject()) continue;
                HashMap<String, String> records = new HashMap<String, String>();
                for (Map.Entry<String, JsonElement> e : elt.getAsJsonObject().entrySet()) {
                    records.put(e.getKey(), e.getValue().getAsString());
                }
                OPERATIONS.put(object.name(), records);
            }
        }
        catch (JsonParseException e) {
            LOG.log(Level.SEVERE, "Could not parse json file: /alchemy_endpoints.json", e);
        }
        catch (NullPointerException e) {
            LOG.log(Level.SEVERE, "Not able to locate the end points json file: /alchemy_endpoints.json", e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Could not close file reader: /alchemy_endpoints.json", e);
                }
            }
        }
    }

    public static String getPath(AlchemyAPI operation, String inputType) {
        if (OPERATIONS.get(operation.name()) != null && OPERATIONS.get(operation.name()).get(inputType) != null) {
            return OPERATIONS.get(operation.name()).get(inputType);
        }
        String error = "Operation: " + (Object)((Object)operation) + ", inputType: " + inputType + " not found";
        LOG.log(Level.SEVERE, error);
        throw new IllegalArgumentException(error);
    }

    static {
        AlchemyEndPoints.loadEndPointsFromJsonFile();
    }

    public static enum AlchemyAPI {
        AUTHORS,
        COMBINED,
        CONCEPTS,
        DATES,
        EMOTION,
        ENTITIES,
        FEEDS,
        IMAGE_KEYWORDS,
        IMAGE_LINK,
        IMAGE_RECOGNITION,
        IMAGE_SCENE_TEXT,
        KEYWORDS,
        LANGUAGE,
        MICROFORMATS,
        PUBLICATION_DATE,
        RELATIONS,
        SENTIMENT,
        SENTIMENT_TARGETED,
        TAXONOMY,
        TEXT,
        TEXT_RAW,
        TITLE,
        TYPED;

    }
}

