/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.AlchemyGenericModel;
import com.ibm.watson.developer_cloud.alchemy.v1.model.CombinedResults;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Concepts;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Dates;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentAuthors;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentEmotion;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentPublicationDate;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentSentiment;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentText;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentTitle;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Entities;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Feeds;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Keywords;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Language;
import com.ibm.watson.developer_cloud.alchemy.v1.model.LanguageSelection;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Microformats;
import com.ibm.watson.developer_cloud.alchemy.v1.model.SAORelations;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Taxonomies;
import com.ibm.watson.developer_cloud.alchemy.v1.model.TypedRelations;
import com.ibm.watson.developer_cloud.alchemy.v1.util.AlchemyEndPoints;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AlchemyLanguage
extends AlchemyService {
    public static final String BASE_URL = "baseUrl";
    public static final String COREFERENCE = "coreference";
    public static final String CQUERY = "cquery";
    public static final String DISAMBIGUATE = "disambiguate";
    public static final String ENTITIES = "entities";
    public static final String EXTRACT = "extract";
    public static final String EXTRACT_LINK = "extractLinks";
    public static final String FORCED_GLOSSARY = "forced_glossary";
    public static final String HTML = "html";
    public static final String KEYWORD_EXTRACT_MODE = "keywordExtractMode";
    public static final String KEYWORDS = "keywords";
    public static final String KNOWLEDGE_GRAPH = "knowledgeGraph";
    public static final String LINKED_DATA = "linkedData";
    public static final String MAX_RETRIEVE = "maxRetrieve";
    public static final String QUOTATIONS = "quotations";
    public static final String RAW = "raw";
    public static final String REQUIRED_ENTITIES = "requireEntities";
    public static final String SENTIMENT = "sentiment";
    public static final String SENTIMENT_EXCLUDE_ENTITIES = "sentimentExcludeEntities";
    public static final String SHOW_SOURCE_TEXT = "showSourceText";
    public static final String SOURCE_TEXT = "sourceText";
    public static final String STRUCTURED_ENTITIES = "structuredEntities";
    public static final String TARGET = "target";
    public static final String TEXT = "text";
    public static final String URL = "url";
    public static final String USE_METADATA = "useMetadata";
    public static final String XPATH = "xpath";
    public static final String TARGETS = "targets";
    public static final String ANCHOR_DATE = "anchorDate";
    public static final String MODEL_ID = "model_id";
    private LanguageSelection language = LanguageSelection.DETECT;
    private static final SimpleDateFormat anchorDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String LANGUAGE = "language";

    public AlchemyLanguage() {
    }

    public AlchemyLanguage(String apiKey) {
        super(apiKey);
    }

    private <T extends AlchemyGenericModel> ServiceCall<T> createServiceCall(Map<String, Object> params, AlchemyEndPoints.AlchemyAPI operation, Class<T> returnType, String ... acceptedFormats) {
        HashMap<String, Object> paramsCopy = new HashMap<String, Object>(params);
        String format = this.getInputFormat(paramsCopy, acceptedFormats);
        String path = AlchemyEndPoints.getPath(operation, format);
        paramsCopy.put("outputMode", "json");
        if (!paramsCopy.containsKey(LANGUAGE) && this.language != LanguageSelection.DETECT) {
            paramsCopy.put(LANGUAGE, this.language.toString().toLowerCase());
        }
        paramsCopy.remove("jsonp");
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        for (String param : paramsCopy.keySet()) {
            requestBuilder.form(param, paramsCopy.get(param));
        }
        if (operation == AlchemyEndPoints.AlchemyAPI.TYPED && params.containsKey(MODEL_ID)) {
            requestBuilder.query(MODEL_ID, params.get(MODEL_ID));
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(returnType));
    }

    public void setLanguage(LanguageSelection language) {
        this.language = language;
    }

    public ServiceCall<DocumentAuthors> getAuthors(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.AUTHORS, DocumentAuthors.class, HTML, URL);
    }

    public ServiceCall<Concepts> getConcepts(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.CONCEPTS, Concepts.class, TEXT, HTML, URL);
    }

    public ServiceCall<DocumentPublicationDate> getPublicationDate(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.PUBLICATION_DATE, DocumentPublicationDate.class, HTML, URL);
    }

    public ServiceCall<Taxonomies> getTaxonomy(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.TAXONOMY, Taxonomies.class, TEXT, HTML, URL);
    }

    public ServiceCall<CombinedResults> getCombinedResults(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.COMBINED, CombinedResults.class, TEXT, HTML, URL);
    }

    public ServiceCall<Entities> getEntities(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.ENTITIES, Entities.class, TEXT, HTML, URL);
    }

    public ServiceCall<Feeds> getFeeds(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.FEEDS, Feeds.class, HTML, URL);
    }

    public ServiceCall<Keywords> getKeywords(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.KEYWORDS, Keywords.class, TEXT, HTML, URL);
    }

    public ServiceCall<Language> getLanguage(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.LANGUAGE, Language.class, TEXT, HTML, URL);
    }

    public ServiceCall<Microformats> getMicroformats(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.MICROFORMATS, Microformats.class, HTML, URL);
    }

    public ServiceCall<SAORelations> getRelations(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.RELATIONS, SAORelations.class, TEXT, HTML, URL);
    }

    public ServiceCall<DocumentSentiment> getSentiment(Map<String, Object> params) {
        AlchemyEndPoints.AlchemyAPI operation = AlchemyEndPoints.AlchemyAPI.SENTIMENT;
        if (params.get(TARGET) != null || params.get(TARGETS) != null) {
            operation = AlchemyEndPoints.AlchemyAPI.SENTIMENT_TARGETED;
        }
        return this.createServiceCall(params, operation, DocumentSentiment.class, TEXT, HTML, URL);
    }

    public ServiceCall<DocumentText> getText(Map<String, Object> params) {
        AlchemyEndPoints.AlchemyAPI operation = AlchemyEndPoints.AlchemyAPI.TEXT;
        if (params.get(RAW) != null) {
            operation = AlchemyEndPoints.AlchemyAPI.TEXT_RAW;
        }
        return this.createServiceCall(params, operation, DocumentText.class, HTML, URL);
    }

    public ServiceCall<DocumentTitle> getTitle(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.TITLE, DocumentTitle.class, HTML, URL);
    }

    public ServiceCall<DocumentEmotion> getEmotion(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.EMOTION, DocumentEmotion.class, TEXT, HTML, URL);
    }

    public ServiceCall<TypedRelations> getTypedRelations(Map<String, Object> params) {
        return this.createServiceCall(params, AlchemyEndPoints.AlchemyAPI.TYPED, TypedRelations.class, TEXT, HTML, URL);
    }

    public ServiceCall<Dates> getDates(Map<String, Object> params) {
        HashMap<String, Object> paramsCopy = new HashMap<String, Object>(params);
        if (params.containsKey(ANCHOR_DATE) && params.get(ANCHOR_DATE) instanceof Date) {
            String anchorDate = anchorDateFormat.format(params.get(ANCHOR_DATE));
            paramsCopy.put(ANCHOR_DATE, anchorDate);
        }
        return this.createServiceCall(paramsCopy, AlchemyEndPoints.AlchemyAPI.DATES, Dates.class, TEXT, HTML, URL);
    }
}

