/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentsResult;
import com.ibm.watson.developer_cloud.alchemy.v1.model.VolumeResult;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class AlchemyDataNews
extends AlchemyService {
    private static final String JSON = "json";
    private static final String NEWS_END_POINT = "/data/GetNews";
    public static final String COUNT = "count";
    public static final String END = "end";
    public static final String RETURN = "return";
    public static final String START = "start";
    public static final String TIME_SLICE = "timeSlice";

    public AlchemyDataNews() {
    }

    public AlchemyDataNews(String apiKey) {
        super(apiKey);
    }

    public ServiceCall<DocumentsResult> getNewsDocuments(Map<String, Object> parameters) {
        Validator.notNull(parameters.get(START), "start time cannot be null");
        Validator.notNull(parameters.get(END), "end time cannot be null");
        Validator.notNull(parameters.get(RETURN), "return cannot be null");
        HashMap<String, Object> parametersCopy = new HashMap<String, Object>(parameters);
        parametersCopy.put("outputMode", JSON);
        parametersCopy.remove("jsonp");
        RequestBuilder requestBuilder = RequestBuilder.get(NEWS_END_POINT);
        for (String param : parametersCopy.keySet()) {
            requestBuilder.query(param, parametersCopy.get(param));
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(DocumentsResult.class));
    }

    public ServiceCall<VolumeResult> getVolume(String start, String end, String timeSlice) {
        Validator.notNull(start, "start time cannot be null");
        Validator.notNull(end, "end time cannot be null");
        RequestBuilder requestBuilder = RequestBuilder.get(NEWS_END_POINT);
        requestBuilder.query(START, start);
        requestBuilder.query(END, end);
        requestBuilder.query("outputMode", JSON);
        if (timeSlice != null) {
            requestBuilder.query(TIME_SLICE, timeSlice);
        }
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(VolumeResult.class));
    }
}

