/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.BadRequestException;
import com.ibm.watson.developer_cloud.service.ConflictException;
import com.ibm.watson.developer_cloud.service.ForbiddenException;
import com.ibm.watson.developer_cloud.service.InternalServerErrorException;
import com.ibm.watson.developer_cloud.service.NotFoundException;
import com.ibm.watson.developer_cloud.service.RequestTooLargeException;
import com.ibm.watson.developer_cloud.service.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.ServiceUnavailableException;
import com.ibm.watson.developer_cloud.service.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.UnauthorizedException;
import com.ibm.watson.developer_cloud.service.UnsupportedException;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.CredentialUtils;
import com.ibm.watson.developer_cloud.util.RequestUtil;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WatsonService {
    private static final String BASIC = "Basic ";
    private static final Logger log = Logger.getLogger(WatsonService.class.getName());
    private String apiKey;
    private final OkHttpClient client;
    private String endPoint;
    private final String name;
    private Headers defaultHeaders = null;
    protected static final String VERSION = "version";

    public WatsonService(String name) {
        this.name = name;
        this.apiKey = CredentialUtils.getAPIKey(name);
        this.client = this.configureHttpClient();
    }

    protected OkHttpClient configureHttpClient() {
        OkHttpClient client = new OkHttpClient();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        client.setCookieHandler((CookieHandler)cookieManager);
        client.setConnectTimeout(60L, TimeUnit.SECONDS);
        client.setWriteTimeout(60L, TimeUnit.SECONDS);
        client.setReadTimeout(90L, TimeUnit.SECONDS);
        return client;
    }

    protected Response execute(Request request) {
        Response response;
        Request.Builder builder = request.newBuilder();
        if (RequestUtil.isRelative(request)) {
            builder.url(RequestUtil.replaceEndPoint(request.urlString(), this.getEndPoint()));
        }
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
        }
        builder.header("User-Agent", this.getUserAgent());
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        log.log(Level.FINEST, "Request to: " + newRequest.urlString());
        try {
            response = this.client.newCall(newRequest).execute();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException", e);
            throw new RuntimeException(e);
        }
        if (response.isSuccessful()) {
            return response;
        }
        int status = response.code();
        String error = this.getErrorMessage(response);
        log.log(Level.SEVERE, newRequest.urlString() + ", status: " + status + ", error: " + error);
        switch (status) {
            case 400: {
                throw new BadRequestException(error != null ? error : "Bad Request", response);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials", response);
            }
            case 403: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 404: {
                throw new NotFoundException(error != null ? error : "Not found", response);
            }
            case 406: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 409: {
                throw new ConflictException(error != null ? error : "", response);
            }
            case 413: {
                throw new RequestTooLargeException(error != null ? error : "Request too large: The request entity is larger than the server is able to process", response);
            }
            case 415: {
                throw new UnsupportedException(error != null ? error : "Unsupported Media Type", response);
            }
            case 429: {
                throw new TooManyRequestsException(error != null ? error : "Too many requests", response);
            }
            case 500: {
                throw new InternalServerErrorException(error != null ? error : "Internal Server Error", response);
            }
            case 503: {
                throw new ServiceUnavailableException(error != null ? error : "Service Unavailable", response);
            }
        }
        throw new ServiceResponseException(status, error, response);
    }

    protected <T extends GenericModel> T executeRequest(Request request, Class<T> returnType) {
        Response response = this.execute(request);
        return ResponseUtil.getObject(response, returnType);
    }

    protected void executeWithoutResponse(Request request) {
        Response response = this.execute(request);
        try {
            response.body().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getToken() {
        HttpUrl url = HttpUrl.parse((String)this.getEndPoint()).newBuilder().setPathSegment(0, "authorization").build();
        Request request = RequestBuilder.get(url + "/v1/token").withQuery("url", this.getEndPoint()).build();
        Response response = this.execute(request);
        return ResponseUtil.getJsonObject(response).get("token").getAsString();
    }

    private String getErrorMessage(Response response) {
        String error = ResponseUtil.getString(response);
        try {
            JsonObject jsonObject = ResponseUtil.getJsonObject(error);
            if (jsonObject.has("error")) {
                error = jsonObject.get("error").getAsString();
            } else if (jsonObject.has("error_message")) {
                error = jsonObject.get("error_message").getAsString();
            } else if (jsonObject.has("message")) {
                error = jsonObject.get("message").getAsString();
            }
        }
        catch (JsonIOException jsonIOException) {
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return error;
    }

    public String getName() {
        return this.name;
    }

    private final String getUserAgent() {
        return "watson-developer-cloud-java-sdk-2.9.0";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("apiKey or username and password were not specified");
        }
        builder.addHeader("Authorization", this.apiKey.startsWith(BASIC) ? this.apiKey : BASIC + this.apiKey);
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.apiKey = Credentials.basic((String)username, (String)password);
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = Headers.of(headers);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(" [");
        if (this.endPoint != null) {
            builder.append("endPoint=");
            builder.append(this.endPoint);
        }
        builder.append("]");
        return builder.toString();
    }
}

