/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Taxonomy;
import java.io.IOException;

public class TaxonomyTypeAdapter
extends TypeAdapter<Taxonomy> {
    public Taxonomy read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        Taxonomy taxonomy = new Taxonomy();
        taxonomy.setConfident(true);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("confident")) {
                String confidentAsString = reader.nextString();
                taxonomy.setConfident(confidentAsString == null || !confidentAsString.equals("no"));
                continue;
            }
            if (name.equals("label")) {
                String label = reader.nextString();
                taxonomy.setLabel(label);
                continue;
            }
            if (name.equals("score")) {
                Double score = reader.nextDouble();
                taxonomy.setScore(score);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return taxonomy;
    }

    public void write(JsonWriter writer, Taxonomy value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.getScore() != null) {
            writer.name("score").value((Number)value.getScore());
        }
        if (value.getConfident() != null) {
            writer.name("confident").value(value.getConfident().booleanValue());
        }
        if (value.getLabel() != null) {
            writer.name("label").value(value.getLabel());
        }
        writer.endObject();
        writer.flush();
    }
}

