/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.squareup.okhttp.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class RequestUtil {
    public static final String DEFAULT_ENDPOINT = "http://do.not.use";

    public static String encode(String content) {
        try {
            return URLEncoder.encode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isRelative(Request request) {
        return request.urlString().startsWith(DEFAULT_ENDPOINT);
    }

    public static Map<String, Object> omit(Map<String, Object> params, String ... toOmit) {
        if (params == null) {
            return null;
        }
        if (toOmit == null || toOmit.length == 0) {
            return params;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : params.keySet()) {
            if (ArrayUtils.contains(toOmit, key)) continue;
            ret.put(key, params.get(key));
        }
        return ret;
    }

    public static Map<String, Object> pick(Map<String, Object> params, String ... toPick) {
        if (params == null) {
            return null;
        }
        if (toPick == null || toPick.length == 0) {
            return params;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : params.keySet()) {
            if (!ArrayUtils.contains(toPick, key)) continue;
            ret.put(key, params.get(key));
        }
        return ret;
    }

    public static String replaceEndPoint(String url, String endPoint) {
        return endPoint + url.replaceFirst(DEFAULT_ENDPOINT, "");
    }
}

