/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.squareup.okhttp.Credentials;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CredentialUtils {
    private static final String ALCHEMY_API = "alchemy_api";
    private static final String APIKEY = "apikey";
    private static final String CREDENTIALS = "credentials";
    private static final Logger log = Logger.getLogger(CredentialUtils.class.getName());
    private static final String PASSWORD = "password";
    private static final String PLAN = "plan";
    public static final String PLAN_EXPERIMENTAL = "experimental";
    public static final String PLAN_FREE = "free";
    public static final String PLAN_STANDARD = "standard";
    private static String services;
    private static final String USERNAME = "username";

    public static String getAPIKey(String serviceName) {
        return CredentialUtils.getAPIKey(serviceName, null);
    }

    public static String getAPIKey(String serviceName, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVCAPServices();
        if (services == null) {
            return CredentialUtils.getKeyUsingJNDI(serviceName);
        }
        for (Map.Entry<String, JsonElement> entry : services.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(serviceName)) continue;
            JsonArray servInstances = services.getAsJsonArray(key);
            for (JsonElement instance : servInstances) {
                JsonObject service = instance.getAsJsonObject();
                String instancePlan = service.get(PLAN).getAsString();
                if (plan != null && !plan.equalsIgnoreCase(instancePlan)) continue;
                JsonObject credentials = instance.getAsJsonObject().getAsJsonObject(CREDENTIALS);
                if (serviceName.equalsIgnoreCase(ALCHEMY_API)) {
                    return credentials.get(APIKEY).getAsString();
                }
                String username = credentials.get(USERNAME).getAsString();
                String password = credentials.get(PASSWORD).getAsString();
                return Credentials.basic(username, password);
            }
        }
        return null;
    }

    private static String getKeyUsingJNDI(String serviceName) {
        try {
            Class.forName("javax.naming.Context");
            try {
                InitialContext context = new InitialContext();
                String lookupName = "watson-developer-cloud/" + serviceName + "/credentials";
                String apiKey = (String)context.lookup(lookupName);
                return apiKey;
            }
            catch (NamingException e) {
                return null;
            }
        }
        catch (ClassNotFoundException exception) {
            log.info("JNDI string lookups is not available.");
            return null;
        }
    }

    private static JsonObject getVCAPServices() {
        String envServices;
        String string = envServices = services != null ? services : System.getenv("VCAP_SERVICES");
        if (envServices == null) {
            return null;
        }
        JsonObject vcapServices = null;
        try {
            JsonParser parser = new JsonParser();
            vcapServices = (JsonObject)parser.parse(envServices);
        }
        catch (JsonSyntaxException e) {
            log.log(Level.INFO, "Error parsing VCAP_SERVICES", e);
        }
        return vcapServices;
    }

    public static void setServices(String services) {
        CredentialUtils.services = services;
    }
}

