/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v3;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tone_analyzer.v3.model.ToneAnalysis;
import com.squareup.okhttp.Request;

public class ToneAnalyzer
extends WatsonService {
    private static final String VERSION_DATE = "version";
    private static final String PATH_TONE = "/v3/tone";
    private static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/tone-analyzer-beta/api";
    private String versionDate;
    public static final String VERSION_DATE_2016_02_11 = "2016-02-11";

    public ToneAnalyzer(String versionDate) {
        super("tone_analyzer");
        this.setEndPoint(URL);
        this.versionDate = versionDate;
    }

    public ToneAnalysis getTone(String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text cannot be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(TEXT, text);
        Request request = RequestBuilder.post(PATH_TONE).withQuery(VERSION_DATE, this.versionDate).withBodyJson(contentJson).build();
        return this.executeRequest(request, ToneAnalysis.class);
    }
}

