/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.speech_to_text.v1.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeDelegate;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WebSocketSpeechToTextClient {
    private static final String MODEL = "model";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String ACTION = "action";
    private static final String RESULTS = "results";
    private static final String ERROR = "error";
    private static final int TEN_SECONDS = 10000;
    private static final int FOUR_KB = 4096;
    private String token;
    private String webSocketUrl;

    public WebSocketSpeechToTextClient(String webSocketUrl, String token) {
        this.token = token;
        this.webSocketUrl = webSocketUrl;
    }

    public void recognize(InputStream stream, RecognizeOptions options, RecognizeDelegate delegate) {
        WebSocketListener listener = new WebSocketListener(delegate);
        try {
            WebSocket ws = this.connect(options);
            ws.addListener(listener);
            ws.sendText(this.buildStartMessage(options));
            this.sendInputStream(ws, stream);
            listener.audioSent = true;
            ws.sendText(this.buildStopMessage());
        }
        catch (WebSocketException e) {
            delegate.onError(e);
        }
        catch (IOException e) {
            delegate.onError(e);
        }
        catch (InterruptedException e) {
            delegate.onError(e);
        }
    }

    private String buildStopMessage() {
        JsonObject stopMessage = new JsonObject();
        stopMessage.addProperty(ACTION, STOP);
        return stopMessage.toString();
    }

    private void sendInputStream(WebSocket ws, InputStream stream) throws IOException, InterruptedException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = stream.read(buffer)) > 0) {
            if (read == 4096) {
                ws.sendBinary(buffer);
            } else {
                ws.sendBinary(Arrays.copyOfRange(buffer, 0, read));
            }
            Thread.sleep(20L);
        }
        stream.close();
    }

    private String buildStartMessage(RecognizeOptions options) {
        JsonObject startMessage = new JsonParser().parse(new Gson().toJson(options)).getAsJsonObject();
        startMessage.remove(MODEL);
        startMessage.addProperty(ACTION, START);
        return startMessage.toString();
    }

    private WebSocket connect(RecognizeOptions options) throws IOException, WebSocketException {
        String speechModel = options.getModel() != null ? "?model=" + options.getModel() : "";
        WebSocketFactory factory = new WebSocketFactory().setConnectionTimeout(10000);
        WebSocket ws = factory.createSocket(this.webSocketUrl + speechModel);
        ws.addHeader("X-Watson-Authorization-Token", this.token);
        ws.addExtension("permessage-deflate").connect();
        return ws;
    }

    public class WebSocketListener
    extends WebSocketAdapter {
        private RecognizeDelegate delegate;
        private boolean audioSent = false;

        public WebSocketListener(RecognizeDelegate delegate) {
            this.delegate = delegate;
            this.audioSent = false;
        }

        @Override
        public void onTextMessage(WebSocket websocket, String message) {
            try {
                JsonObject json = new JsonParser().parse(message).getAsJsonObject();
                if (json.has(WebSocketSpeechToTextClient.ERROR)) {
                    this.delegate.onError(new RuntimeException(json.get(WebSocketSpeechToTextClient.ERROR).getAsString()));
                } else if (json.has(WebSocketSpeechToTextClient.RESULTS)) {
                    SpeechResults transcript = GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(message, SpeechResults.class);
                    this.delegate.onMessage(transcript);
                } else if (this.audioSent) {
                    websocket.sendClose();
                }
            }
            catch (JsonParseException e) {
                new RuntimeException("Error parsing the incoming message: " + message);
            }
        }

        @Override
        public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
            this.delegate.onConnected();
        }

        @Override
        public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
            this.delegate.onDisconnected();
        }

        @Override
        public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
            this.delegate.onError(cause);
        }

        @Override
        public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
            cause.printStackTrace();
        }
    }
}

