/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.speech_to_text.v1.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SessionStatus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModelSet;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.ibm.watson.developer_cloud.speech_to_text.v1.util.MediaTypeUtils;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeDelegate;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.WebSocketSpeechToTextClient;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class SpeechToText
extends WatsonService {
    private static final String CONTINUOUS = "continuous";
    private static final String INACTIVITY_TIMEOUT = "inactivity_timeout";
    private static final String MAX_ALTERNATIVES = "max_alternatives";
    private static final String MODEL = "model";
    private static final String PATH_MODEL = "/v1/models/%s";
    private static final String PATH_MODELS = "/v1/models";
    private static final String PATH_RECOGNIZE = "/v1/recognize";
    private static final String PATH_SESSION = "/v1/sessions/%s";
    private static final String PATH_SESSION_RECOGNIZE = "/v1/sessions/%s/recognize";
    private static final String PATH_SESSIONS = "/v1/sessions";
    private static final String TIMESTAMPS = "timestamps";
    private static final String URL = "https://stream.watsonplatform.net/speech-to-text/api";
    private static final String WORD_CONFIDENCE = "word_confidence";
    private static final String SESSION = "session";
    private static final String KEYWORDS_THRESHOLD = "keywords_threshold";
    private static final String WORD_ALTERNATIVES_THRESHOLD = "word_alternatives_threshold";
    private static final String KEYWORDS = "keywords";

    public SpeechToText() {
        super("speech_to_text");
        this.setEndPoint(URL);
    }

    private void buildRecognizeRequest(RequestBuilder requestBuilder, RecognizeOptions options) {
        if (options == null) {
            return;
        }
        if (options.getWordConfidence() != null) {
            requestBuilder.withQuery(WORD_CONFIDENCE, options.getWordConfidence());
        }
        if (options.getContinuous() != null) {
            requestBuilder.withQuery(CONTINUOUS, options.getContinuous());
        }
        if (options.getMaxAlternatives() != null) {
            requestBuilder.withQuery(MAX_ALTERNATIVES, options.getMaxAlternatives());
        }
        if (options.getTimestamps() != null) {
            requestBuilder.withQuery(TIMESTAMPS, options.getTimestamps());
        }
        if (options.getInactivityTimeout() != null) {
            requestBuilder.withQuery(INACTIVITY_TIMEOUT, options.getInactivityTimeout());
        }
        if (options.getModel() != null) {
            requestBuilder.withQuery(MODEL, options.getModel());
        }
        if (options.getKeywordsThreshold() != null) {
            requestBuilder.withQuery(KEYWORDS_THRESHOLD, options.getKeywordsThreshold());
        }
        if (options.getKeywords() != null && options.getKeywords().length > 0) {
            requestBuilder.withQuery(KEYWORDS, GsonSingleton.getGsonWithoutPrettyPrinting().toJson(options.getKeywords()));
        }
        if (options.getWordAlternativesThreshold() != null) {
            requestBuilder.withQuery(WORD_ALTERNATIVES_THRESHOLD, options.getWordAlternativesThreshold());
        }
    }

    public SpeechSession createSession() {
        String model = null;
        return this.createSession(model);
    }

    public SpeechSession createSession(SpeechModel model) {
        Validate.notNull(model, "model cannot be null");
        return this.createSession(model.getName());
    }

    public SpeechSession createSession(String model) {
        RequestBuilder request = RequestBuilder.post(PATH_SESSIONS);
        if (model != null) {
            request.withQuery(MODEL, model);
        }
        Response response = this.execute(request.build());
        SpeechSession speechSession = ResponseUtil.getObject(response, SpeechSession.class);
        return speechSession;
    }

    public void deleteSession(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        Request request = RequestBuilder.delete(String.format(PATH_SESSION, session.getSessionId())).build();
        Response response = this.execute(request);
        ResponseUtil.getString(response);
        if (response.code() != 204) {
            throw new RuntimeException("Cound't delete session");
        }
    }

    public SpeechModel getModel(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name was not specified");
        }
        Request request = RequestBuilder.get(String.format(PATH_MODEL, name)).build();
        return this.executeRequest(request, SpeechModel.class);
    }

    public List<SpeechModel> getModels() {
        Request request = RequestBuilder.get(PATH_MODELS).build();
        return this.executeRequest(request, SpeechModelSet.class).getModels();
    }

    public SessionStatus getRecognizeStatus(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        Request request = RequestBuilder.get(String.format(PATH_SESSION_RECOGNIZE, session.getSessionId())).build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        return GsonSingleton.getGsonWithoutPrettyPrinting().fromJson(jsonObject.get(SESSION), SessionStatus.class);
    }

    public SpeechResults recognize(File audio) {
        return this.recognize(audio, (RecognizeOptions)null);
    }

    public SpeechResults recognize(File audio, RecognizeOptions options) {
        Validate.isTrue(audio != null && audio.exists(), "audio file is null or does not exist");
        double fileSize = (double)audio.length() / Math.pow(1024.0, 2.0);
        Validate.isTrue(fileSize < 100.0, "The audio file is greater than 100MB.");
        String contentType = MediaTypeUtils.getMediaTypeFromFile(audio);
        if (options != null && options.getContentType() != null) {
            contentType = options.getContentType();
        }
        Validate.notNull(contentType, "The audio format cannot be recognized");
        String path = PATH_RECOGNIZE;
        if (options != null && options.getSessionId() != null && !options.getSessionId().isEmpty()) {
            path = String.format(PATH_SESSION_RECOGNIZE, options.getSessionId());
        }
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        this.buildRecognizeRequest(requestBuilder, options);
        requestBuilder.withBody(RequestBody.create(MediaType.parse(contentType), audio));
        return this.executeRequest(requestBuilder.build(), SpeechResults.class);
    }

    public SpeechResults recognize(File audio, String contentType) {
        return this.recognize(audio, contentType, null);
    }

    public SpeechResults recognize(File audio, String contentType, RecognizeOptions options) {
        RecognizeOptions opt = options;
        if (opt == null) {
            opt = new RecognizeOptions().contentType(contentType);
        }
        return this.recognize(audio, opt);
    }

    public void recognizeUsingWebSockets(InputStream audio, RecognizeOptions options, RecognizeDelegate delegate) {
        Validate.notNull(audio, "audio cannot be null");
        Validate.notNull(options, "options cannot be null");
        Validate.notNull(options.getContentType(), "options.contentType cannot be null");
        Validate.notNull(delegate, "delegate cannot be null");
        String url = this.getEndPoint().replaceFirst("(https|http)", "wss");
        WebSocketSpeechToTextClient webSocket = new WebSocketSpeechToTextClient(url + PATH_RECOGNIZE, this.getToken());
        webSocket.recognize(audio, options, delegate);
    }
}

