/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Content;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Profile;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.ProfileOptions;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.TimestampTypeAdapter;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Response;
import java.lang.reflect.Type;
import java.util.Date;

public class PersonalityInsights
extends WatsonService {
    private static final String PATH_PROFILE = "/v2/profile";
    private static final String INCLUDE_RAW = "include_raw";
    private static final String URL = "https://gateway.watsonplatform.net/personality-insights/api";
    private static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Date.class), new TimestampTypeAdapter()).create();
    private static final String HEADERS = "headers";

    public PersonalityInsights() {
        super("personality_insights");
        this.setEndPoint(URL);
    }

    private RequestBuilder buildProfileRequest(ProfileOptions options) {
        Validate.notNull(options, "options cannot be null");
        Validate.isTrue(options.getText() != null || options.getContentItems() != null, "text, html or content items need to be specified");
        String contentType = options.getContentType();
        RequestBuilder request = RequestBuilder.post(PATH_PROFILE);
        if (options.getText() != null) {
            request.withBodyContent(options.getText(), contentType);
        } else {
            Content content = new Content();
            content.setContentItems(options.getContentItems());
            String body = gson.toJson(content);
            request.withBodyContent(body, contentType);
        }
        if (options.getIncludeRaw() != null) {
            request.withQuery(INCLUDE_RAW, options.getIncludeRaw());
        }
        if (options.getLanguage() != null) {
            request.withHeader(new Object[]{"Content-Language", options.getLanguage()});
        }
        if (options.getAcceptLanguage() != null) {
            request.withHeader(new Object[]{"Accept-Language", options.getAcceptLanguage()});
        }
        return request;
    }

    public Profile getProfile(String text) {
        Validate.notEmpty(text, "text cannot be null or empty");
        ProfileOptions options = new ProfileOptions().text(text);
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        return this.executeRequest(requestBuilder.build(), Profile.class);
    }

    public Profile getProfile(ProfileOptions options) {
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        return this.executeRequest(requestBuilder.build(), Profile.class);
    }

    public String getProfileAsCSV(ProfileOptions options, boolean includeHeaders) {
        RequestBuilder requestBuilder = this.buildProfileRequest(options);
        requestBuilder.withHeader("Accept", "text/csv");
        requestBuilder.withQuery(HEADERS, includeHeaders);
        Response response = this.execute(requestBuilder.build());
        return ResponseUtil.getString(response);
    }
}

