/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translation.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.language_translation.v2.model.CreateModelOptions;
import com.ibm.watson.developer_cloud.language_translation.v2.model.IdentifiableLanguage;
import com.ibm.watson.developer_cloud.language_translation.v2.model.IdentifiedLanguage;
import com.ibm.watson.developer_cloud.language_translation.v2.model.LanguageList;
import com.ibm.watson.developer_cloud.language_translation.v2.model.TranslationModel;
import com.ibm.watson.developer_cloud.language_translation.v2.model.TranslationModelList;
import com.ibm.watson.developer_cloud.language_translation.v2.model.TranslationResult;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.util.List;

public class LanguageTranslation
extends WatsonService {
    private static final String PATH_IDENTIFY = "/v2/identify";
    private static final String PATH_TRANSLATE = "/v2/translate";
    private static final String PATH_IDENTIFIABLE_LANGUAGES = "/v2/identifiable_languages";
    private static final String PATH_MODELS = "/v2/models";
    private static final String BASE_MODEL_ID = "base_model_id";
    private static final String DEFAULT = "default";
    private static final String FORCED_GLOSSARY = "forced_glossary";
    private static final String MODEL_ID = "model_id";
    private static final String MONOLINGUAL_CORPUS = "monolingual_corpus";
    private static final String NAME = "name";
    private static final String PARALLEL_CORPUS = "parallel_corpus";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/language-translation/api";
    private static final String PATH_MODEL = "/v2/models/%s";

    public LanguageTranslation() {
        super("language_translation");
        this.setEndPoint(URL);
    }

    public TranslationModel createModel(CreateModelOptions options) {
        Validate.notNull(options, "options cannot be null");
        Validate.notEmpty(options.getBaseModelId(), "options.baseModelId cannot be null or empty");
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_MODELS);
        requestBuilder.withQuery(BASE_MODEL_ID, options.getBaseModelId());
        if (options.getName() != null) {
            requestBuilder.withQuery(NAME, options.getName());
        }
        MultipartBuilder bodyBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        if (options.getForcedGlossary() != null) {
            bodyBuilder.addFormDataPart(FORCED_GLOSSARY, options.getForcedGlossary().getName(), RequestBody.create(HttpMediaType.BINARY_FILE, options.getForcedGlossary()));
        }
        if (options.getMonolingualCorpus() != null) {
            bodyBuilder.addFormDataPart(MONOLINGUAL_CORPUS, options.getMonolingualCorpus().getName(), RequestBody.create(HttpMediaType.BINARY_FILE, options.getMonolingualCorpus()));
        }
        if (options.getParallelCorpus() != null) {
            bodyBuilder.addFormDataPart(PARALLEL_CORPUS, options.getParallelCorpus().getName(), RequestBody.create(HttpMediaType.BINARY_FILE, options.getParallelCorpus()));
        }
        return this.executeRequest(requestBuilder.withBody(bodyBuilder.build()).build(), TranslationModel.class);
    }

    public void deleteModel(String modelId) {
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("modelId cannot be null or empty");
        }
        Request request = RequestBuilder.delete(String.format(PATH_MODEL, modelId)).build();
        this.executeWithoutResponse(request);
    }

    public List<IdentifiableLanguage> getIdentifiableLanguages() {
        RequestBuilder requestBuilder = RequestBuilder.get(PATH_IDENTIFIABLE_LANGUAGES);
        LanguageList languages = this.executeRequest(requestBuilder.build(), LanguageList.class);
        return languages.getLanguages();
    }

    public TranslationModel getModel(String modelId) {
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("modelId cannot be null or empty");
        }
        Request request = RequestBuilder.get(String.format(PATH_MODEL, modelId)).build();
        return this.executeRequest(request, TranslationModel.class);
    }

    public List<TranslationModel> getModels() {
        return this.getModels(null, null, null);
    }

    public List<TranslationModel> getModels(Boolean showDefault, String source, String target) {
        RequestBuilder requestBuilder = RequestBuilder.get(PATH_MODELS);
        if (source != null && !source.isEmpty()) {
            requestBuilder.withQuery(SOURCE, source);
        }
        if (target != null && !target.isEmpty()) {
            requestBuilder.withQuery(TARGET, source);
        }
        if (showDefault != null) {
            requestBuilder.withQuery(DEFAULT, showDefault);
        }
        TranslationModelList models = this.executeRequest(requestBuilder.build(), TranslationModelList.class);
        return models.getModels();
    }

    public List<IdentifiedLanguage> identify(String text) {
        Request request = RequestBuilder.post(PATH_IDENTIFY).withHeader("Accept", "application/json").withBodyContent(text, "text/plain").build();
        LanguageList languages = this.executeRequest(request, LanguageList.class);
        return languages.getLanguages();
    }

    public TranslationResult translate(String text, String modelId) {
        Validate.isTrue(modelId != null && !modelId.isEmpty(), "modelId cannot be null or empty");
        return this.translateRequest(text, modelId, null, null);
    }

    public TranslationResult translate(String text, String source, String target) {
        Validate.isTrue(source != null && !source.isEmpty(), "source cannot be null or empty");
        Validate.isTrue(target != null && !target.isEmpty(), "target cannot be null or empty");
        return this.translateRequest(text, null, source, target);
    }

    private TranslationResult translateRequest(String text, String modelId, String source, String target) {
        Validate.isTrue(text != null && !text.isEmpty(), "text cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        JsonArray paragraphs = new JsonArray();
        paragraphs.add(new JsonPrimitive(text));
        contentJson.add(TEXT, paragraphs);
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_TRANSLATE).withHeader("Accept", "application/json");
        if (source != null && !source.isEmpty()) {
            contentJson.addProperty(SOURCE, source);
        }
        if (target != null && !target.isEmpty()) {
            contentJson.addProperty(TARGET, target);
        }
        if (modelId != null && !modelId.isEmpty()) {
            contentJson.addProperty(MODEL_ID, modelId);
        }
        requestBuilder.withBodyJson(contentJson);
        return this.executeRequest(requestBuilder.build(), TranslationResult.class);
    }
}

