/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.internal.Util;
import java.io.IOException;
import java.io.InputStream;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private InputStream inputStream;
    private MediaType mediaType;

    public static RequestBody create(MediaType mediaType, InputStream inputStream) {
        return new InputStreamRequestBody(inputStream, mediaType);
    }

    private InputStreamRequestBody(InputStream inputStream, MediaType mediaType) {
        this.inputStream = inputStream;
        this.mediaType = mediaType;
    }

    @Override
    public MediaType contentType() {
        return this.mediaType;
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source(this.inputStream);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly(source);
        }
    }
}

