/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentsResult;
import com.ibm.watson.developer_cloud.alchemy.v1.model.VolumeResult;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.util.Validate;
import java.util.Map;

public class AlchemyDataNews
extends AlchemyService {
    private static final String JSON = "json";
    public static final String COUNT = "count";
    public static final String END = "end";
    private static final String NEWS_END_POINT = "/data/GetNews";
    public static final String RETURN = "return";
    public static final String START = "start";
    public static final String TIME_SLICE = "timeSlice";

    public DocumentsResult getNewsDocuments(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(START), "start time cannot be null");
        Validate.notNull(parameters.get(END), "end time cannot be null");
        Validate.notNull(parameters.get(RETURN), "return cannot be null");
        parameters.put("outputMode", JSON);
        parameters.remove("jsonp");
        RequestBuilder requestBuilder = RequestBuilder.get(NEWS_END_POINT);
        for (String param : parameters.keySet()) {
            requestBuilder.withQuery(param, parameters.get(param));
        }
        return this.executeRequest(requestBuilder.build(), DocumentsResult.class);
    }

    public VolumeResult getVolume(String start, String end, String timeSlice) {
        Validate.notNull(start, "start time cannot be null");
        Validate.notNull(end, "end time cannot be null");
        RequestBuilder requestBuilder = RequestBuilder.get(NEWS_END_POINT);
        requestBuilder.withQuery(START, start);
        requestBuilder.withQuery(END, end);
        requestBuilder.withQuery("outputMode", JSON);
        if (timeSlice != null) {
            requestBuilder.withQuery(TIME_SLICE, timeSlice);
        }
        return this.executeRequest(requestBuilder.build(), VolumeResult.class);
    }

    public static enum TimeFormat {
        d,
        h,
        m,
        M,
        NOW,
        s,
        y;

    }
}

