/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.Scorecard;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.SynonymOptions;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.SynonymResult;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.Tone;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.lang.reflect.Type;
import java.util.List;

public class ToneAnalyzer
extends WatsonService {
    private static final String PATH_SYNONYM = "/v1/synonym";
    private static final String PATH_TONE = "/v1/tone";
    private static final String SCORECARD = "scorecard";
    private static final Type synonymListType = new TypeToken<List<SynonymResult>>(){}.getType();
    private static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/tone-analyzer-experimental/api";
    private static final String PATH_SCORECARD = "/v2/scorecards";
    private static final String SCORECARDS = "scorecards";
    private final Type scorecardListType = new TypeToken<List<Scorecard>>(){}.getType();

    public ToneAnalyzer() {
        super("tone_analyzer");
        this.setEndPoint(URL);
    }

    public List<SynonymResult> getSynonyms(SynonymOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null");
        }
        if (options.getWords() == null || options.getWords().isEmpty()) {
            throw new IllegalArgumentException("options.words cannot be null or empty");
        }
        Request request = RequestBuilder.post(PATH_SYNONYM).withBodyContent(GsonSingleton.getGson().toJson((Object)options), "application/json").build();
        Response response = this.execute(request);
        String synonymResultJson = ResponseUtil.getString(response);
        List synonyms = (List)GsonSingleton.getGson().fromJson(synonymResultJson, synonymListType);
        return synonyms;
    }

    public Tone getTone(String text) {
        return this.getTone(text, null);
    }

    public Tone getTone(String text, Scorecard scorecard) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text cannot be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(TEXT, text);
        if (scorecard != null) {
            contentJson.addProperty(SCORECARD, scorecard.getId());
        }
        Request request = RequestBuilder.post(PATH_TONE).withBodyJson(contentJson).build();
        return this.executeRequest(request, Tone.class);
    }

    public List<Scorecard> getScorecards() {
        Response response = this.execute(RequestBuilder.get(PATH_SCORECARD).build());
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List scorecards = (List)GsonSingleton.getGson().fromJson(jsonObject.get(SCORECARDS), this.scorecardListType);
        return scorecards;
    }
}

