/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.speech_to_text.v1.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SessionStatus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModelSet;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.util.List;

public class SpeechToText
extends WatsonService {
    private static final String CONTINUOUS = "continuous";
    private static final String INACTIVITY_TIMEOUT = "inactivity_timeout";
    private static final String MAX_ALTERNATIVES = "max_alternatives";
    private static final String MODEL = "model";
    private static final String PATH_MODEL = "/v1/models/%s";
    private static final String PATH_MODELS = "/v1/models";
    private static final String PATH_RECOGNIZE = "/v1/recognize";
    private static final String PATH_SESSION = "/v1/sessions/%s";
    private static final String PATH_SESSION_RECOGNIZE = "/v1/sessions/%s/recognize";
    private static final String PATH_SESSIONS = "/v1/sessions";
    private static final String TIMESTAMPS = "timestamps";
    private static final String URL = "https://stream.watsonplatform.net/speech-to-text/api";
    private static final String WORD_CONFIDENCE = "word_confidence";
    private static final String SESSION = "session";

    public SpeechToText() {
        super("speech_to_text");
        this.setEndPoint(URL);
    }

    private void buildRecognizeRequest(RequestBuilder requestBuilder, RecognizeOptions options) {
        if (options == null) {
            return;
        }
        if (options.getWordConfidence() != null) {
            requestBuilder.withQuery(WORD_CONFIDENCE, options.getWordConfidence());
        }
        if (options.getContinuous() != null) {
            requestBuilder.withQuery(CONTINUOUS, options.getContinuous());
        }
        if (options.getMaxAlternatives() != null) {
            requestBuilder.withQuery(MAX_ALTERNATIVES, options.getMaxAlternatives());
        }
        if (options.getTimestamps() != null) {
            requestBuilder.withQuery(TIMESTAMPS, options.getTimestamps());
        }
        if (options.getInactivityTimeout() != null) {
            requestBuilder.withQuery(INACTIVITY_TIMEOUT, options.getInactivityTimeout());
        }
        if (options.getModel() != null) {
            requestBuilder.withQuery(MODEL, options.getModel());
        }
    }

    public SpeechSession createSession() {
        String model = null;
        return this.createSession(model);
    }

    public SpeechSession createSession(SpeechModel model) {
        Validate.notNull(model, "model cannot be null");
        return this.createSession(model.getName());
    }

    public SpeechSession createSession(String model) {
        RequestBuilder request = RequestBuilder.post(PATH_SESSIONS);
        if (model != null) {
            request.withQuery(MODEL, model);
        }
        Response response = this.execute(request.build());
        SpeechSession speechSession = ResponseUtil.getObject(response, SpeechSession.class);
        return speechSession;
    }

    public void deleteSession(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        Request request = RequestBuilder.delete(String.format(PATH_SESSION, session.getSessionId())).build();
        Response response = this.execute(request);
        ResponseUtil.getString(response);
        if (response.code() != 204) {
            throw new RuntimeException("Cound't delete session");
        }
    }

    public SpeechModel getModel(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name was not specified");
        }
        Request request = RequestBuilder.get(String.format(PATH_MODEL, name)).build();
        return this.executeRequest(request, SpeechModel.class);
    }

    public List<SpeechModel> getModels() {
        Request request = RequestBuilder.get(PATH_MODELS).build();
        return this.executeRequest(request, SpeechModelSet.class).getModels();
    }

    public SessionStatus getRecognizeStatus(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        Request request = RequestBuilder.get(String.format(PATH_SESSION_RECOGNIZE, session.getSessionId())).build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        return (SessionStatus)GsonSingleton.getGson().fromJson(jsonObject.get(SESSION), SessionStatus.class);
    }

    public SpeechResults recognize(File audio, String contentType) {
        return this.recognize(audio, contentType, null);
    }

    public SpeechResults recognize(File audio, String contentType, RecognizeOptions options) {
        Validate.isTrue(audio != null && audio.exists(), "audio is not a valid audio file");
        Validate.isTrue((double)(audio.length() / 0x100000L) < 100.0, "The audio file is greater than 100MB.");
        Validate.isTrue(MediaType.parse((String)contentType) != null, "contentType is not a valid audio format");
        String path = PATH_RECOGNIZE;
        if (!(options == null || options.getSessionId() == null && options.getSessionId().isEmpty())) {
            path = String.format(PATH_SESSION_RECOGNIZE, options.getSessionId());
        }
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        this.buildRecognizeRequest(requestBuilder, options);
        requestBuilder.withBody(RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)audio));
        return this.executeRequest(requestBuilder.build(), SpeechResults.class);
    }
}

