/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.retrieve_and_rank.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.ClusterLifecycleManager;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.SolrConfigManager;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Ranker;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Rankers;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.Ranking;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrCluster;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterList;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrClusterOptions;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.model.SolrConfigList;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.ZipUtils;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetrieveAndRank
extends WatsonService
implements ClusterLifecycleManager,
SolrConfigManager {
    private static final String ANSWERS = "answers";
    private static final Logger log = Logger.getLogger(RetrieveAndRank.class.getName());
    private static final String NAME = "name";
    private static final String PATH_CREATE_RANKER = "/v1/rankers";
    private static final String PATH_GET_SOLR_CLUSTER = "/v1/solr_clusters/%s";
    private static final String PATH_SOLR = "/v1/solr_clusters/%s/solr";
    private static final String PATH_RANK = "/v1/rankers/%s/rank";
    private static final String PATH_RANKER = "/v1/rankers/%s";
    private static final String PATH_RANKERS = "/v1/rankers";
    private static final String PATH_SOLR_CLUSTERS = "/v1/solr_clusters";
    private static final String PATH_SOLR_CLUSTERS_CONFIG = "/v1/solr_clusters/%s/config";
    private static final String PATH_SOLR_CLUSTERS_CONFIGS = "/v1/solr_clusters/%s/config/%s";
    private static final String URL = "https://gateway.watsonplatform.net/retrieve-and-rank/api";

    public RetrieveAndRank() {
        super("retrieve_and_rank");
        this.setEndPoint(URL);
    }

    private String createConfigPath(String solrClusterId, String configName) {
        Validate.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Validate.isTrue(configName != null && !configName.isEmpty(), "configName cannot be null or empty");
        return String.format(PATH_SOLR_CLUSTERS_CONFIGS, solrClusterId, configName);
    }

    public Ranker createRanker(String name, File training) {
        Validate.notNull(training, "training file cannot be null");
        Validate.isTrue(training.exists(), "training file: " + training.getAbsolutePath() + " not found");
        JsonObject contentJson = new JsonObject();
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty(NAME, name);
        }
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"training_data\""}), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)training)).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"training_metadata\""}), RequestBody.create((MediaType)HttpMediaType.TEXT, (String)contentJson.toString())).build();
        Request request = RequestBuilder.post("/v1/rankers").withBody(body).build();
        return this.executeRequest(request, Ranker.class);
    }

    @Override
    public SolrCluster createSolrCluster() {
        return this.createSolrCluster(null);
    }

    @Override
    public SolrCluster createSolrCluster(SolrClusterOptions config) {
        RequestBuilder requestBuilder = RequestBuilder.post(PATH_SOLR_CLUSTERS);
        if (config != null) {
            requestBuilder.withBodyContent(GsonSingleton.getGson().toJson((Object)config), "application/json");
        }
        return this.executeRequest(requestBuilder.build(), SolrCluster.class);
    }

    public void deleteRanker(String rankerID) {
        Validate.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerId cannot be null or empty");
        Request request = RequestBuilder.delete(String.format(PATH_RANKER, rankerID)).build();
        this.executeWithoutResponse(request);
    }

    @Override
    public void deleteSolrCluster(String solrClusterId) {
        Validate.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.delete(String.format(PATH_GET_SOLR_CLUSTER, solrClusterId)).build();
        this.executeWithoutResponse(request);
    }

    @Override
    public void deleteSolrClusterConfiguration(String solrClusterId, String configName) {
        String configPath = this.createConfigPath(solrClusterId, configName);
        Request request = RequestBuilder.delete(configPath).build();
        this.executeWithoutResponse(request);
    }

    public Rankers getRankers() {
        Request request = RequestBuilder.get("/v1/rankers").build();
        Response response = this.execute(request);
        return ResponseUtil.getObject(response, Rankers.class);
    }

    public Ranker getRankerStatus(String rankerID) {
        Validate.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_RANKER, rankerID)).build();
        return this.executeRequest(request, Ranker.class);
    }

    @Override
    public SolrCluster getSolrCluster(String solrClusterId) {
        Validate.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_GET_SOLR_CLUSTER, solrClusterId)).build();
        return this.executeRequest(request, SolrCluster.class);
    }

    @Override
    public InputStream getSolrClusterConfiguration(String solrClusterId, String configName) {
        Validate.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Validate.isTrue(configName != null && !configName.isEmpty(), "configName cannot be null or empty");
        String configPath = this.createConfigPath(solrClusterId, configName);
        RequestBuilder requestBuider = RequestBuilder.get(configPath);
        requestBuider.withHeader("Accept", "application/zip").build();
        Response response = this.execute(requestBuider.build());
        return ResponseUtil.getInputStream(response);
    }

    public List<String> getSolrClusterConfigurations(String solrClusterId) {
        Validate.isTrue(solrClusterId != null && !solrClusterId.isEmpty(), "solrClusterId cannot be null or empty");
        Request request = RequestBuilder.get(String.format(PATH_SOLR_CLUSTERS_CONFIG, solrClusterId)).build();
        SolrConfigList configList = this.executeRequest(request, SolrConfigList.class);
        return configList.getSolrConfigs();
    }

    @Override
    public SolrClusterList getSolrClusters() {
        Request request = RequestBuilder.get(PATH_SOLR_CLUSTERS).build();
        return this.executeRequest(request, SolrClusterList.class);
    }

    public String getSolrUrl(String solrClusterId) {
        return this.getEndPoint() + String.format(PATH_SOLR, solrClusterId);
    }

    public Ranking rank(String rankerID, File answers, Integer topAnswers) {
        Validate.isTrue(rankerID != null && !rankerID.isEmpty(), "rankerID cannot be null or empty");
        Validate.notNull(answers, "answers file cannot be null");
        Validate.isTrue(answers.exists(), "answers file: " + answers.getAbsolutePath() + " not found");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(ANSWERS, (Number)(topAnswers != null && topAnswers > 0 ? topAnswers : 10));
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"answer_data\""}), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)answers)).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"answer_metadata\""}), RequestBody.create((MediaType)HttpMediaType.TEXT, (String)contentJson.toString())).build();
        String path = String.format(PATH_RANK, rankerID);
        Request request = RequestBuilder.post(path).withBody(body).build();
        return this.executeRequest(request, Ranking.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadSolrClusterConfigurationDirectory(String solrClusterId, String configName, File directory) {
        Validate.notNull(directory, "directory cannot be null");
        Validate.isTrue(directory.exists(), "directory: " + directory.getAbsolutePath() + " not found");
        Validate.isTrue(directory.isDirectory(), "directory is not a directory");
        File zipFile = ZipUtils.buildConfigZip(configName, directory.toPath());
        try {
            this.uploadSolrClusterConfigurationZip(solrClusterId, configName, zipFile);
        }
        finally {
            try {
                Files.delete(zipFile.toPath());
            }
            catch (IOException e) {
                zipFile.deleteOnExit();
                log.log(Level.WARNING, "Error deleting the solr cluster configuration file", e);
            }
        }
    }

    @Override
    public void uploadSolrClusterConfigurationZip(String solrClusterId, String configName, File zippedConfig) {
        String configPath = this.createConfigPath(solrClusterId, configName);
        RequestBuilder requestBuilder = RequestBuilder.post(configPath);
        requestBuilder.withBody(RequestBody.create((MediaType)MediaType.parse((String)"application/zip"), (File)zippedConfig));
        this.executeWithoutResponse(requestBuilder.build());
    }
}

