/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Answers;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionTarget;
import com.ibm.watson.developer_cloud.document_conversion.v1.util.ConversionUtils;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentConversion
extends WatsonService {
    private static final Logger LOG = Logger.getLogger(DocumentConversion.class.getName());
    private static final String CONVERSION_TARGET = "conversion_target";
    private static final String CONVERT_DOCUMENT_PATH = "/v1/convert_document";
    private static final String URL = "https://gateway.watsonplatform.net/document-conversion-experimental/api";

    public DocumentConversion() {
        super("document_conversion");
        this.setEndPoint(URL);
    }

    private InputStream convertDocument(File document, String mediaType, ConversionTarget conversionTarget) {
        String type;
        if (document == null || !document.exists()) {
            throw new IllegalArgumentException("document cannot be null and must exist");
        }
        String string = type = mediaType != null ? mediaType : ConversionUtils.getMediaTypeFromFile(document);
        if (type == null) {
            throw new RuntimeException("mediaType cannot be null or empty");
        }
        if (!ConversionUtils.isValidMediaType(type).booleanValue()) {
            throw new IllegalArgumentException("file with the given media type is not supported");
        }
        JsonObject configJson = new JsonObject();
        configJson.addProperty(CONVERSION_TARGET, conversionTarget.toString());
        MediaType mType = MediaType.parse((String)type);
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"config\""}), RequestBody.create((MediaType)HttpMediaType.JSON, (String)configJson.toString())).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\""}), RequestBody.create((MediaType)mType, (File)document)).build();
        Request request = RequestBuilder.post(CONVERT_DOCUMENT_PATH).withBody(body).build();
        Response response = this.execute(request);
        return ResponseUtil.getInputStream(response);
    }

    public Answers convertDocumentToAnswer(File document) {
        return this.convertDocumentToAnswer(document, null);
    }

    public Answers convertDocumentToAnswer(File document, String mediaType) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.ANSWER_UNITS);
        String convertedDocument = ConversionUtils.writeInputStreamToString(is);
        try {
            is.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to close document input stream", e);
        }
        return (Answers)GsonSingleton.getGson().fromJson(convertedDocument, Answers.class);
    }

    public String convertDocumentToHTML(File document) {
        return this.convertDocumentToHTML(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertDocumentToHTML(File document, String mediaType) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.NORMALIZED_HTML);
        try {
            String string = ConversionUtils.writeInputStreamToString(is);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to close document input stream", e);
            }
        }
    }

    public String convertDocumentToText(File document) {
        return this.convertDocumentToText(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertDocumentToText(File document, String mediaType) {
        InputStream is = this.convertDocument(document, mediaType, ConversionTarget.NORMALIZED_TEXT);
        try {
            String string = ConversionUtils.writeInputStreamToString(is);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to close document input stream", e);
            }
        }
    }
}

