/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Part;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validate;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Document
extends GenericModel {
    private String id;
    private String label;
    @SerializedName(value="last_modified")
    private Date lastModified;
    private String name;
    private List<Part> parts;
    @SerializedName(value="user_fields")
    private Map<String, String> userFields;

    public Document() {
    }

    public Document(Corpus corpus, String concept) {
        Validate.notNull(corpus, "corpus cannot be null");
        Validate.notEmpty(corpus.getId(), "corpus.id cannot be empty");
        this.setName(concept);
        this.setId(corpus.getId() + "/documents/" + concept);
    }

    public Document(String accountId, String corpusName, String document) {
        Validate.notEmpty(document, "document cannot be empty");
        this.setName(document);
        this.setId(new Corpus(accountId, corpusName).getId() + "/documents/" + document);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public Map<String, String> getUserFields() {
        return this.userFields;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public void setUserFields(Map<String, String> userFields) {
        this.userFields = userFields;
    }
}

