/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.AlchemyGenericModel;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageFaces;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageKeywords;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageLink;
import com.ibm.watson.developer_cloud.alchemy.v1.util.AlchemyEndPoints;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AlchemyVision
extends AlchemyService {
    public static final String FORCE_SHOW_ALL = "forceShowAll";
    public static final String HTML = "html";
    public static final String IMAGE = "image";
    public static final String IMAGE_POST_MODE = "imagePostMode";
    public static final String KNOWLEDGE_GRAPH = "knowledgeGraph";
    public static final String NOT_RAW = "not-raw";
    public static final String RAW = "raw";
    public static final String URL = "url";

    private <T extends AlchemyGenericModel> T executeRequest(Map<String, Object> params, AlchemyEndPoints.AlchemyAPI operation, Class<T> returnType) {
        String inputType = this.getInputFormat(params, IMAGE, URL, HTML);
        String path = AlchemyEndPoints.getPath(operation, inputType);
        RequestBuilder requestBuilder = RequestBuilder.post(path);
        if (inputType == IMAGE) {
            if (params.get(IMAGE) instanceof String) {
                params.put(IMAGE_POST_MODE, NOT_RAW);
            } else {
                params.put(IMAGE_POST_MODE, RAW);
                File image = (File)params.get(IMAGE);
                if (!image.exists()) {
                    throw new IllegalArgumentException("The file: " + image.getAbsolutePath() + " does not exist.");
                }
                requestBuilder.withBody(RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)((File)params.get(IMAGE))));
                params.remove(IMAGE);
            }
        }
        params.put("outputMode", "json");
        for (String param : params.keySet()) {
            if (inputType.equals(IMAGE)) {
                requestBuilder.withQuery(param, params.get(param));
                continue;
            }
            requestBuilder.withForm(param, params.get(param));
        }
        return (T)((AlchemyGenericModel)this.executeRequest(requestBuilder.build(), returnType));
    }

    public ImageKeywords getImageKeywords(File image, Boolean forceShowAll, Boolean knowledgeGraph) {
        Validate.notNull(image, "image cannot be null");
        Validate.isTrue(image.exists(), "image file: " + image.getAbsolutePath() + " not found");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMAGE, image);
        if (forceShowAll != null) {
            params.put(FORCE_SHOW_ALL, forceShowAll != false ? 1 : 0);
        }
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_keywords, ImageKeywords.class);
    }

    public ImageKeywords getImageKeywords(URL url, Boolean forceShowAll, Boolean knowledgeGraph) {
        Validate.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        if (forceShowAll != null) {
            params.put(FORCE_SHOW_ALL, forceShowAll != false ? 1 : 0);
        }
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_keywords, ImageKeywords.class);
    }

    public ImageLink getImageLink(URL url) {
        Validate.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_link, ImageLink.class);
    }

    public ImageLink getImageLink(String html) {
        Validate.notNull(html, "html cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(HTML, html);
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_link, ImageLink.class);
    }

    public ImageFaces recognizeFaces(File image, Boolean knowledgeGraph) {
        Validate.notNull(image, "image cannot be null");
        Validate.isTrue(image.exists(), "image file: " + image.getAbsolutePath() + " not found");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMAGE, image);
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_recognition, ImageFaces.class);
    }

    public ImageFaces recognizeFaces(URL url, Boolean knowledgeGraph) {
        Validate.notNull(url, "url cannot be null");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(URL, url);
        if (knowledgeGraph != null) {
            params.put(KNOWLEDGE_GRAPH, knowledgeGraph != false ? 1 : 0);
        }
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_recognition, ImageFaces.class);
    }
}

