/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v1;

import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.visual_recognition.v1.model.LabelSet;
import com.ibm.watson.developer_cloud.visual_recognition.v1.model.VisualRecognitionImages;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.RequestBody;
import java.io.File;

public class VisualRecognition
extends WatsonService {
    public static final String IMG_FILE = "imgFile";
    public static final String LABELS_TO_CHECK = "labels_to_check";
    private static final String URL = "https://gateway.watsonplatform.net/visual-recognition-beta/api";

    public VisualRecognition() {
        super("visual_recognition");
        this.setEndPoint(URL);
    }

    public LabelSet getLabelSet() {
        return this.executeRequest(RequestBuilder.get("/v1/tag/labels").build(), LabelSet.class);
    }

    public VisualRecognitionImages recognize(File image) {
        return this.recognize(image, null);
    }

    public VisualRecognitionImages recognize(File image, LabelSet labelSet) {
        if (image == null) {
            throw new IllegalArgumentException("image cannot be null");
        }
        RequestBuilder requestBuilder = RequestBuilder.post("/v1/tag/recognize");
        MultipartBuilder bodyBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        bodyBuilder.addFormDataPart(IMG_FILE, image.getName(), RequestBody.create(HttpMediaType.BINARY_FILE, image));
        if (labelSet != null) {
            bodyBuilder.addFormDataPart(LABELS_TO_CHECK, GsonSingleton.getGson().toJson(labelSet));
        }
        requestBuilder.withBody(bodyBuilder.build());
        return this.executeRequest(requestBuilder.build(), VisualRecognitionImages.class);
    }
}

