/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_insights.v1;

import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.visual_insights.v1.model.Classifiers;
import com.ibm.watson.developer_cloud.visual_insights.v1.model.Summary;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.RequestBody;
import java.io.File;

public class VisualInsights
extends WatsonService {
    private static final String CLASSIFIERS_PATH = "/v1/classifiers";
    public static final String FILTER_NAME = "filter_name";
    private static final String IMAGES_FILE = "images_file";
    private static final String SUMMARY_PATH = "/v1/summary";
    private static final String URL = "https://gateway.watsonplatform.net/visual-insights-experimental/api";

    public VisualInsights() {
        super("visual_insights");
        this.setEndPoint(URL);
    }

    public Classifiers getClassifiers() {
        return this.getClassifiers(null);
    }

    public Classifiers getClassifiers(String name) {
        RequestBuilder requestBuilder = RequestBuilder.get(CLASSIFIERS_PATH);
        if (name != null && !name.isEmpty()) {
            requestBuilder.withQuery(FILTER_NAME, name);
        }
        return this.executeRequest(requestBuilder.build(), Classifiers.class);
    }

    public Summary getSummary(File imagesFile) {
        if (imagesFile == null || !imagesFile.exists()) {
            throw new IllegalArgumentException("imagesFile cannot be null or empty");
        }
        MediaType mediaType = HttpMediaType.BINARY_FILE;
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart(IMAGES_FILE, imagesFile.getName(), RequestBody.create(mediaType, imagesFile)).build();
        RequestBuilder requestBuilder = RequestBuilder.post(SUMMARY_PATH).withBody(body);
        return this.executeRequest(requestBuilder.build(), Summary.class);
    }
}

