/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseUtil {
    private static final String ERROR_MESSAGE = "Error reading the http response";
    private static final Logger log = Logger.getLogger(ResponseUtil.class.getName());

    public static InputStream getInputStream(Response response) {
        try {
            return response.body().byteStream();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ERROR_MESSAGE, e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }

    public static String getResponseString(Response response) {
        try {
            return response.body().string();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ERROR_MESSAGE, e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }

    public static JsonElement getJsonElement(Response response) {
        try {
            return new JsonParser().parse(response.body().charStream());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ERROR_MESSAGE, e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }

    public static JsonObject getJsonObject(Response response) {
        return ResponseUtil.getJsonElement(response).getAsJsonObject();
    }

    public static JsonObject getJsonObject(String jsonString) {
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    public static <T extends GenericModel> T getObject(Response response, Class<T> type) {
        String jsonString = ResponseUtil.getString(response);
        GenericModel model = (GenericModel)GsonSingleton.getGson().fromJson(jsonString, type);
        return (T)model;
    }

    public static String getString(Response response) {
        try {
            return response.body().string();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, ERROR_MESSAGE, e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }
}

