/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.service.BadRequestException;
import com.ibm.watson.developer_cloud.service.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.UnauthorizedException;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class AlchemyService
extends WatsonService {
    protected static final String ENDPOINT = "https://gateway-a.watsonplatform.net/calls";
    protected static final String JSONP = "jsonp";
    private static final String DAILY_TRANSACTION_LIMIT_EXCEEDED = "daily-transaction-limit-exceeded";
    private static final String INVALID_API_KEY = "invalid-api-key";
    private static final Logger log = Logger.getLogger(AlchemyService.class.getName());
    private static final String MESSAGE_CODE = "code";
    private static final String MESSAGE_ERROR = "error";
    protected static final String OUTPUT_MODE = "outputMode";
    private static final String PARAM_APIKEY = "apikey";
    private static final String STATUS_ERROR = "ERROR";
    private static final String X_ALCHEMY_API_ERROR_MSG = "X-AlchemyAPI-Error-Msg";
    private static final String X_ALCHEMY_API_STATUS = "X-AlchemyAPI-Status";

    public AlchemyService() {
        super("alchemy_api");
        this.setEndPoint(ENDPOINT);
    }

    private void addApiKeyToRequest(Request.Builder builder, String apiKey) {
        HttpUrl url = HttpUrl.parse(builder.build().urlString());
        if (url.query() == null || url.query().isEmpty()) {
            builder.url(builder.build().url() + "?" + apiKey);
        } else {
            builder.url(builder.build().url() + "&" + apiKey);
        }
    }

    private int detectErrorCode(String errorMessage) {
        String error;
        String string = error = errorMessage != null ? errorMessage : null;
        if (error == null) {
            return 400;
        }
        if (error.equals(DAILY_TRANSACTION_LIMIT_EXCEEDED)) {
            return 429;
        }
        if (error.equals(INVALID_API_KEY)) {
            return 401;
        }
        return 400;
    }

    @Override
    protected Response execute(Request request) {
        Response response = super.execute(request);
        JsonObject error = this.getErrorMessage(response);
        if (error == null) {
            return response;
        }
        log.log(Level.SEVERE, error.toString());
        int code = error.get(MESSAGE_CODE).getAsInt();
        switch (code) {
            case 400: {
                throw new BadRequestException(error.toString(), response);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials", response);
            }
            case 429: {
                throw new TooManyRequestsException(error.toString(), response);
            }
        }
        throw new ServiceResponseException(code, error.toString(), response);
    }

    @Override
    protected <T extends GenericModel> T executeRequest(Request request, Class<T> returnType) {
        Response response = this.execute(request);
        return ResponseUtil.getObject(response, returnType);
    }

    private JsonObject getErrorMessage(Response response) {
        String status = response.header(X_ALCHEMY_API_STATUS);
        String errorMessage = response.header(X_ALCHEMY_API_ERROR_MSG);
        if (status != null && status.equals(STATUS_ERROR)) {
            int code = this.detectErrorCode(errorMessage);
            JsonObject error = new JsonObject();
            error.addProperty(MESSAGE_ERROR, errorMessage != null ? errorMessage : "Unknown error");
            error.addProperty(MESSAGE_CODE, code);
            return error;
        }
        return null;
    }

    protected String getInputFormat(Map<String, Object> params, String ... acceptedFormats) {
        int i;
        for (i = 0; i < acceptedFormats.length && params != null && !params.containsKey(acceptedFormats[i]); ++i) {
        }
        if (params == null || i == acceptedFormats.length) {
            throw new IllegalArgumentException(StringUtils.join((Object[])acceptedFormats, ",") + " should be specified");
        }
        return acceptedFormats[i];
    }

    @Override
    protected void setAuthentication(Request.Builder builder) {
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("apiKey not specified");
        }
        this.addApiKeyToRequest(builder, "apikey=" + this.getApiKey());
    }
}

