/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util;

import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.MessageFormatter;
import com.ibm.watson.developer_cloud.retrieve_and_rank.v1.util.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
    private static final MessageFormatter MSGS = new MessageFormatter(Messages.bundleName());

    private ZipUtils() {
    }

    public static File buildConfigZip(String configName, final Path parentDir) {
        ZipOutputStream out;
        File zipFile = ZipUtils.createEmptyZipFile(configName);
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_ZIPPING_1, parentDir.toString()), e);
        }
        try {
            Files.walkFileTree(parentDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    ZipUtils.writeZipEntry(out, parentDir.relativize(path).toString(), Files.readAllBytes(path));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    throw new IllegalStateException(MSGS.format(Messages.FAILED_TO_VISIT_1, file.toAbsolutePath().getFileName()));
                }
            });
            File e = zipFile;
            return e;
        }
        catch (IOException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_ZIPPING_1, parentDir.toString()), e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static File createEmptyZipFile(String prefix) {
        try {
            return File.createTempFile(prefix, ".zip");
        }
        catch (IOException e) {
            throw new RuntimeException(MSGS.format(Messages.ERROR_CREATING_ZIP_1, prefix + ".zip"), e);
        }
    }

    private static void writeZipEntry(ZipOutputStream out, String name, byte[] data) throws IOException {
        ZipEntry entry = new ZipEntry(StringUtils.removeStart(name, "/"));
        out.putNextEntry(entry);
        out.write(data, 0, data.length);
        out.closeEntry();
    }
}

