/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.relationship_extraction.v1;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.relationship_extraction.v1.model.Dataset;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

public class RelationshipExtraction
extends WatsonService {
    private static final String URL = "https://gateway.watsonplatform.net/relationship-extraction-beta/api";
    private Dataset dataset;

    public RelationshipExtraction() {
        super("relatonship_extraction");
        this.setEndPoint(URL);
    }

    public String extract(String text) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        Request request = RequestBuilder.post("/v1/sire/0").withForm("sid", this.dataset.getId(), "rt", "xml", "txt", text).build();
        Response response = this.execute(request);
        return ResponseUtil.getString(response);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }
}

