/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassifiedClass;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifiers;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;

public class NaturalLanguageClassifier
extends WatsonService {
    private static final String FORM_DATA_TRAINING_DATA = "form-data; name=\"training_data\"";
    private static final String PATH_CLASSIFIERS = "/v1/classifiers";
    private static final String TEXT = "text";
    private static final String PATH_CLASSIFY = "/v1/classifiers/%s/classify";
    private static final String LANGUAGE = "language";
    public static final String LANGUAGE_EN = "en";
    private static final String NAME = "name";
    private static final String TRAINING_METADATA = "training_metadata";
    private static final String PATH_CLASSIFIER = "/v1/classifiers/%s";
    private static String URL = "https://gateway.watsonplatform.net/natural-language-classifier/api";

    public NaturalLanguageClassifier() {
        super("natural_language_classifier");
        this.setEndPoint(URL);
    }

    public Classification classify(String classifierId, String text) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId cannot be null or empty");
        }
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text cannot be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(TEXT, text);
        String path = String.format(PATH_CLASSIFY, classifierId);
        Request request = RequestBuilder.post(path).withBodyJson(contentJson).build();
        Response response = this.execute(request);
        Classification classification = ResponseUtil.getObject(response, Classification.class);
        for (ClassifiedClass klass : classification.getClasses()) {
            if (!klass.getName().equals(classification.getTopClass())) continue;
            classification.setTopConfidence(klass.getConfidence());
            break;
        }
        return classification;
    }

    public Classifier createClassifier(String name, String language, File trainingData) {
        Validate.isTrue(trainingData != null && trainingData.exists(), "trainingData cannot be null or not be found");
        Validate.isTrue(language != null && !language.isEmpty(), "language cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(LANGUAGE, language);
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty(NAME, name);
        }
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of("Content-Disposition", FORM_DATA_TRAINING_DATA), RequestBody.create(HttpMediaType.BINARY_FILE, trainingData)).addFormDataPart(TRAINING_METADATA, contentJson.toString()).build();
        Request request = RequestBuilder.post(PATH_CLASSIFIERS).withBody(body).build();
        Response response = this.execute(request);
        return ResponseUtil.getObject(response, Classifier.class);
    }

    public void deleteClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId cannot be null or empty");
        }
        Request request = RequestBuilder.delete(String.format(PATH_CLASSIFIER, classifierId)).build();
        this.executeWithoutResponse(request);
    }

    public Classifier getClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId cannot be null or empty");
        }
        Request request = RequestBuilder.get(String.format(PATH_CLASSIFIER, classifierId)).build();
        return this.executeRequest(request, Classifier.class);
    }

    public Classifiers getClassifiers() {
        Request request = RequestBuilder.get(PATH_CLASSIFIERS).build();
        return this.executeRequest(request, Classifiers.class);
    }
}

