/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.util;

import java.io.File;
import java.io.InputStream;
import java.util.Scanner;

public class ConversionUtils {
    public static String getMediaTypeFromFile(File file) {
        if (file != null) {
            String fileName = file.getName().toLowerCase();
            String[] supportedExtensions = new String[]{".htm", ".html", ".dot", ".doc", ".docx", ".xml", ".xhtml", ".pdf"};
            String[] supportedMediaTypes = new String[]{"text/html", "text/html", "application/msword", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/xhtml+xml", "application/xhtml+xml", "application/pdf"};
            for (int i = 0; i < supportedMediaTypes.length; ++i) {
                if (!fileName.endsWith(supportedExtensions[i])) continue;
                return supportedMediaTypes[i];
            }
        }
        return null;
    }

    public static Boolean isValidMediaType(String mediaType) {
        if (mediaType != null) {
            String[] supportedMediaTypes;
            for (String supportedMediaType : supportedMediaTypes = new String[]{"text/html", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/xhtml+xml", "application/pdf"}) {
                if (!mediaType.equalsIgnoreCase(supportedMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public static String writeInputStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        try {
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        finally {
            s.close();
        }
    }
}

