/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.dialog.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.dialog.v1.model.Conversation;
import com.ibm.watson.developer_cloud.dialog.v1.model.ConversationData;
import com.ibm.watson.developer_cloud.dialog.v1.model.Dialog;
import com.ibm.watson.developer_cloud.dialog.v1.model.DialogContent;
import com.ibm.watson.developer_cloud.dialog.v1.model.NameValue;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DialogService
extends WatsonService {
    private static final String CONVERSATIONS = "conversations";
    private static final String PATH_DIALOG_CONVERSATION = "/v1/dialogs/%s/conversation";
    public static final String CLIENT_ID = "client_id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String DATE_FROM = "date_from";
    public static final String DATE_TO = "date_to";
    public static final String DIALOG_ID = "dialog_id";
    private static final String FILE = "file";
    public static final String INPUT = "input";
    public static final String LIMIT = "limit";
    private static final Type listConversationDataType = new TypeToken<List<ConversationData>>(){}.getType();
    private static final Type listDialogContentType = new TypeToken<List<DialogContent>>(){}.getType();
    private static final Type listDialogType = new TypeToken<List<Dialog>>(){}.getType();
    private static Type listNameValueType = new TypeToken<List<NameValue>>(){}.getType();
    private static final Logger log = Logger.getLogger(DialogService.class.getName());
    private static final String NAME = "name";
    public static final String NAME_VALUES = "name_values";
    public static final String OFFSET = "offset";
    private static final String PATH_DIALOGS = "/v1/dialogs";
    private static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String URL = "https://gateway.watsonplatform.net/dialog-beta/api";
    private static final String PATH_PROFILE = "/v1/dialogs/%s/profile";
    private static final String PATH_DIALOG_CONTENT = "/v1/dialogs/%s/content";
    private static final String PATH_DIALOG = "/v1/dialogs/%s";

    public DialogService() {
        super("dialog");
        this.setEndPoint(URL);
    }

    public Conversation converse(Conversation conversation, String newMessage) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DIALOG_ID, conversation.getDialogId());
        params.put(INPUT, newMessage);
        params.put(CLIENT_ID, conversation.getClientId());
        params.put(CONVERSATION_ID, conversation.getId());
        return this.converse(params);
    }

    public Conversation converse(Map<String, Object> params) {
        String dialogId = (String)params.get(DIALOG_ID);
        String input = (String)params.get(INPUT);
        Integer clientId = (Integer)params.get(CLIENT_ID);
        Integer conversationId = (Integer)params.get(CONVERSATION_ID);
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialog id cannot be null or empty");
        }
        if (conversationId == null) {
            log.info("Creating a new conversation with for dialog: " + dialogId);
        }
        if (clientId == null) {
            log.info("Creating a new client id with for dialog: " + dialogId);
        }
        String path = String.format(PATH_DIALOG_CONVERSATION, dialogId);
        Request request = RequestBuilder.post(path).withForm(CONVERSATION_ID, conversationId, CLIENT_ID, clientId, INPUT, input).build();
        Conversation conversation = this.executeRequest(request, Conversation.class);
        conversation.setDialogId(dialogId);
        return conversation;
    }

    public Conversation createConversation(String dialogId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DIALOG_ID, dialogId);
        return this.converse(params);
    }

    public Dialog createDialog(String name, File dialogFile) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (dialogFile == null || !dialogFile.exists()) {
            throw new IllegalArgumentException("dialogFile cannot be null or empty");
        }
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart(FILE, dialogFile.getName(), RequestBody.create(HttpMediaType.BINARY_FILE, dialogFile)).addFormDataPart(NAME, name).build();
        Request request = RequestBuilder.post(PATH_DIALOGS).withBody(body).build();
        return this.executeRequest(request, Dialog.class);
    }

    public void deleteDialog(String dialogId) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId cannot be null or empty");
        }
        Request request = RequestBuilder.delete(String.format(PATH_DIALOG, dialogId)).build();
        this.executeWithoutResponse(request);
    }

    public List<DialogContent> getContent(String dialogId) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId cannot be null or empty");
        }
        Request request = RequestBuilder.get(String.format(PATH_DIALOG_CONTENT, dialogId)).build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List content = (List)GsonSingleton.getGson().fromJson(jsonObject.get("items"), listDialogContentType);
        return content;
    }

    public List<ConversationData> getConversationData(Map<String, Object> params) {
        String dialogId = (String)params.get(DIALOG_ID);
        Date from = (Date)params.get(DATE_FROM);
        Date to = (Date)params.get(DATE_TO);
        Integer offset = (Integer)params.get(OFFSET);
        Integer limit = (Integer)params.get(LIMIT);
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialog_id cannot be null or empty");
        }
        if (from == null) {
            throw new IllegalArgumentException("date_from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("date_to cannot be null");
        }
        if (from.after(to)) {
            throw new IllegalArgumentException("'date_from' is greater than 'date_to'");
        }
        String fromString = sdfDate.format(from);
        String toString = sdfDate.format(to);
        String path = String.format(PATH_DIALOG_CONVERSATION, dialogId);
        RequestBuilder requestBuilder = RequestBuilder.get(path).withQuery(DATE_FROM, fromString, DATE_TO, toString);
        if (offset != null) {
            requestBuilder.withQuery(OFFSET, offset);
        }
        if (limit != null) {
            requestBuilder.withQuery(LIMIT, limit);
        }
        Request request = requestBuilder.build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List conversationDataList = (List)GsonSingleton.getGson().fromJson(jsonObject.get(CONVERSATIONS), listConversationDataType);
        return conversationDataList;
    }

    public List<Dialog> getDialogs() {
        Request request = RequestBuilder.get(PATH_DIALOGS).build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List dialogs = (List)GsonSingleton.getGson().fromJson(jsonObject.get("dialogs"), listDialogType);
        return dialogs;
    }

    public Map<String, String> getProfile(String dialogId, Integer clientId, String ... names) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId cannot be null or empty");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("clientId cannot be null");
        }
        RequestBuilder requestbuilder = RequestBuilder.get(String.format(PATH_PROFILE, dialogId)).withQuery(CLIENT_ID, clientId);
        if (names != null) {
            for (String name : names) {
                requestbuilder.withQuery(NAME, name);
            }
        }
        Request request = requestbuilder.build();
        Response response = this.execute(request);
        JsonObject jsonObject = ResponseUtil.getJsonObject(response);
        List nameValues = (List)GsonSingleton.getGson().fromJson(jsonObject.get(NAME_VALUES), listNameValueType);
        return this.fromNameValues(nameValues);
    }

    private Map<String, String> fromNameValues(List<NameValue> nameValues) {
        HashMap<String, String> profile = new HashMap<String, String>();
        for (NameValue nameValue : nameValues) {
            profile.put(nameValue.getName(), nameValue.getValue());
        }
        return profile;
    }

    public Dialog updateDialog(String dialogId, File dialogFile) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId cannot be null or empty");
        }
        if (dialogFile == null || !dialogFile.exists()) {
            throw new IllegalArgumentException("dialogFile cannot be null or empty");
        }
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart(FILE, dialogFile.getName(), RequestBody.create(HttpMediaType.BINARY_FILE, dialogFile)).build();
        Request request = RequestBuilder.put(String.format(PATH_DIALOG, dialogId)).withBody(body).build();
        this.executeWithoutResponse(request);
        Dialog dialog = new Dialog().withDialogId(dialogId);
        return dialog;
    }

    public void updateProfile(String dialogId, Integer clientId, Map<String, String> profile) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId cannot be null or empty");
        }
        if (profile == null || profile.isEmpty()) {
            throw new IllegalArgumentException("profile cannot be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        if (clientId != null) {
            contentJson.addProperty(CLIENT_ID, clientId);
        }
        contentJson.add(NAME_VALUES, GsonSingleton.getGson().toJsonTree(this.toNameValue(profile)));
        Request request = RequestBuilder.put(String.format(PATH_PROFILE, dialogId)).withBodyJson(contentJson).build();
        this.executeWithoutResponse(request);
    }

    private List<NameValue> toNameValue(Map<String, String> profile) {
        ArrayList<NameValue> nameValues = new ArrayList<NameValue>();
        for (String key : profile.keySet()) {
            nameValues.add(new NameValue(key, profile.get(key)));
        }
        return nameValues;
    }
}

