/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graph;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validate;

public class Concept
extends GenericModel {
    private String id;
    private String label;
    private String name;

    public Concept() {
    }

    public Concept(Graph graph, String concept) {
        Validate.notNull(graph, "graph cannot be null");
        Validate.notNull(graph.getId(), "graph.id cannot be null");
        this.setName(concept);
        this.setId(graph.getId() + "/concepts/" + concept);
    }

    public Concept(String accountId, String graphName, String concept) {
        Validate.notNull(concept, "concept cannot be null");
        this.setName(concept);
        this.setId(new Graph(accountId, graphName).getId() + "/concepts/" + concept);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }
}

