/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.dialog.v1.model;

import com.ibm.watson.developer_cloud.util.Validator;
import java.util.Date;

public class ConversationDataOptions {
    private String dialogId;
    private Date from;
    private Integer limit;
    private Integer offset;
    private Date to;

    private ConversationDataOptions(Builder builder) {
        this.dialogId = builder.dialogId;
        this.from = builder.from;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.to = builder.to;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String dialogId() {
        return this.dialogId;
    }

    public Date from() {
        return this.from;
    }

    public Integer limit() {
        return this.limit;
    }

    public Integer offset() {
        return this.offset;
    }

    public Date to() {
        return this.to;
    }

    public static class Builder {
        private String dialogId;
        private Date from;
        private Integer limit;
        private Integer offset;
        private Date to;

        public Builder() {
        }

        private Builder(ConversationDataOptions options) {
            this.dialogId = options.dialogId;
            this.from = options.from;
            this.limit = options.limit;
            this.offset = options.offset;
            this.to = options.to;
        }

        public ConversationDataOptions build() {
            Validator.notNull((Object)this.dialogId, (String)"dialogId cannot be null");
            return new ConversationDataOptions(this);
        }

        public Builder dialogId(String dialogId) {
            this.dialogId = dialogId;
            return this;
        }

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }
    }
}

