/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.dialog.v1;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.dialog.v1.model.Conversation;
import com.ibm.watson.developer_cloud.dialog.v1.model.ConversationData;
import com.ibm.watson.developer_cloud.dialog.v1.model.ConversationDataOptions;
import com.ibm.watson.developer_cloud.dialog.v1.model.Dialog;
import com.ibm.watson.developer_cloud.dialog.v1.model.DialogContent;
import com.ibm.watson.developer_cloud.dialog.v1.model.NameValue;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@Deprecated
public class DialogService
extends WatsonService {
    private static final String CLIENT_ID = "client_id";
    private static final String CONVERSATION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String CONVERSATION_ID = "conversation_id";
    private static final String CONVERSATIONS = "conversations";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String DATE_FROM = "date_from";
    private static final String DATE_TO = "date_to";
    private static final String DIALOGS = "dialogs";
    private static final String FILE = "file";
    private static final Gson GSON = GsonSingleton.getGsonWithoutPrettyPrinting();
    private static final String INPUT = "input";
    private static final String ITEMS = "items";
    private static final String LIMIT = "limit";
    private static final Type listConversationDataType = new TypeToken<List<ConversationData>>(){}.getType();
    private static final Type listDialogContentType = new TypeToken<List<DialogContent>>(){}.getType();
    private static final Type listDialogType = new TypeToken<List<Dialog>>(){}.getType();
    private static final Type listNameValueType = new TypeToken<List<NameValue>>(){}.getType();
    private static final String NAME = "name";
    private static final String NAME_VALUES = "name_values";
    private static final String OFFSET = "offset";
    private static final String PATH_DIALOG = "/v1/dialogs/%s";
    private static final String PATH_DIALOG_CONTENT = "/v1/dialogs/%s/content";
    private static final String PATH_DIALOG_CONVERSATION = "/v1/dialogs/%s/conversation";
    private static final String PATH_DIALOGS = "/v1/dialogs";
    private static final String PATH_PROFILE = "/v1/dialogs/%s/profile";
    private static final String SERVICE_NAME = "dialog";
    private static final String URL = "https://gateway.watsonplatform.net/dialog/api";

    public DialogService() {
        super(SERVICE_NAME);
        this.setEndPoint(URL);
    }

    public DialogService(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    private Map<String, String> fromNameValues(List<NameValue> nameValues) {
        HashMap<String, String> profile = new HashMap<String, String>();
        for (NameValue nameValue : nameValues) {
            profile.put(nameValue.getName(), nameValue.getValue());
        }
        return profile;
    }

    private List<NameValue> toNameValue(Map<String, String> profile) {
        ArrayList<NameValue> nameValues = new ArrayList<NameValue>();
        for (String key : profile.keySet()) {
            nameValues.add(new NameValue(key, profile.get(key)));
        }
        return nameValues;
    }

    public ServiceCall<Conversation> converse(final Conversation conversation, String newMessage) {
        Validator.notNull((Object)((Object)conversation), (String)"conversation cannot be null");
        Validator.isTrue((conversation.getDialogId() != null && !conversation.getDialogId().isEmpty() ? 1 : 0) != 0, (String)"conversation.dialogId cannot be null or empty");
        String path = String.format(PATH_DIALOG_CONVERSATION, conversation.getDialogId());
        RequestBuilder requestBuilder = RequestBuilder.post((String)path);
        requestBuilder.form(new Object[]{CONVERSATION_ID, conversation.getId()});
        requestBuilder.form(new Object[]{CLIENT_ID, conversation.getClientId()});
        requestBuilder.form(new Object[]{INPUT, newMessage});
        return this.createServiceCall(requestBuilder.build(), (ResponseConverter)new ResponseConverter<Conversation>(){

            public Conversation convert(Response response) {
                Conversation newConversation = (Conversation)ResponseUtils.getObject((Response)response, Conversation.class);
                newConversation.setDialogId(conversation.getDialogId());
                return newConversation;
            }
        });
    }

    public ServiceCall<Conversation> createConversation(String dialogId) {
        Conversation conversation = new Conversation();
        conversation.setDialogId(dialogId);
        return this.converse(conversation, null);
    }

    public ServiceCall<Dialog> createDialog(String name, File dialogFile) {
        Validator.isTrue((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"name cannot be null or empty");
        Validator.isTrue((dialogFile != null && dialogFile.exists() ? 1 : 0) != 0, (String)"dialogFile cannot be null or inexistent");
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(FILE, dialogFile.getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)dialogFile)).addFormDataPart(NAME, name).build();
        Request request = RequestBuilder.post((String)PATH_DIALOGS).body((RequestBody)body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Dialog.class));
    }

    public ServiceCall<Void> deleteDialog(String dialogId) {
        Validator.isTrue((dialogId != null && !dialogId.isEmpty() ? 1 : 0) != 0, (String)"dialogId cannot be null or empty");
        Request request = RequestBuilder.delete((String)String.format(PATH_DIALOG, dialogId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<List<DialogContent>> getContent(String dialogId) {
        Validator.isTrue((dialogId != null && !dialogId.isEmpty() ? 1 : 0) != 0, (String)"dialogId cannot be null or empty");
        Request request = RequestBuilder.get((String)String.format(PATH_DIALOG_CONTENT, dialogId)).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)listDialogContentType, (String)ITEMS);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<List<ConversationData>> getConversationData(ConversationDataOptions options) {
        Validator.notNull((Object)options, (String)"options cannot be null");
        Validator.isTrue((options.dialogId() != null && !options.dialogId().isEmpty() ? 1 : 0) != 0, (String)"options.dialogId cannot be null or empty");
        Validator.notNull((Object)options.from(), (String)"options.from cannot be null");
        Validator.notNull((Object)options.to(), (String)"options.to cannot be null");
        if (options.from().after(options.to())) {
            throw new IllegalArgumentException("options.from is greater than options.to");
        }
        String fromString = DATE_FORMATTER.format(options.from());
        String toString = DATE_FORMATTER.format(options.to());
        String path = String.format(PATH_DIALOG_CONVERSATION, options.dialogId());
        RequestBuilder requestBuilder = RequestBuilder.get((String)path).query(new Object[]{DATE_FROM, fromString, DATE_TO, toString});
        if (options.offset() != null) {
            requestBuilder.query(new Object[]{OFFSET, options.offset()});
        }
        if (options.limit() != null) {
            requestBuilder.query(new Object[]{LIMIT, options.limit()});
        }
        Request request = requestBuilder.build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)listConversationDataType, (String)CONVERSATIONS);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<List<Dialog>> getDialogs() {
        Request request = RequestBuilder.get((String)PATH_DIALOGS).build();
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)listDialogType, (String)DIALOGS);
        return this.createServiceCall(request, converter);
    }

    public ServiceCall<Map<String, String>> getProfile(Conversation conversation, String ... names) {
        Validator.notNull((Object)((Object)conversation), (String)"conversation cannot be null");
        return this.getProfile(conversation.getDialogId(), conversation.getClientId(), names);
    }

    public ServiceCall<Map<String, String>> getProfile(String dialogId, Integer clientId, String ... names) {
        Validator.isTrue((dialogId != null && !dialogId.isEmpty() ? 1 : 0) != 0, (String)"dialogId cannot be null or empty");
        Validator.notNull((Object)clientId, (String)"clientId cannot be null");
        RequestBuilder requestBuilder = RequestBuilder.get((String)String.format(PATH_PROFILE, dialogId)).query(new Object[]{CLIENT_ID, clientId});
        if (names != null) {
            for (String name : names) {
                requestBuilder.query(new Object[]{NAME, name});
            }
        }
        return this.createServiceCall(requestBuilder.build(), (ResponseConverter)new ResponseConverter<Map<String, String>>(){

            public Map<String, String> convert(Response response) {
                JsonObject jsonObject = ResponseUtils.getJsonObject((Response)response);
                List nameValues = (List)GSON.fromJson(jsonObject.get(DialogService.NAME_VALUES), listNameValueType);
                return DialogService.this.fromNameValues(nameValues);
            }
        });
    }

    public ServiceCall<Void> updateDialog(String dialogId, File dialogFile) {
        Validator.isTrue((dialogId != null && !dialogId.isEmpty() ? 1 : 0) != 0, (String)"dialogId cannot be null or empty");
        Validator.isTrue((dialogFile != null && dialogFile.exists() ? 1 : 0) != 0, (String)"dialogFile cannot be null or inexistent");
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(FILE, dialogFile.getName(), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)dialogFile)).build();
        Request request = RequestBuilder.put((String)String.format(PATH_DIALOG, dialogId)).body((RequestBody)body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> updateProfile(Conversation conversation, Map<String, String> profile) {
        Validator.notNull((Object)((Object)conversation), (String)"conversation cannot be null");
        return this.updateProfile(conversation.getDialogId(), conversation.getClientId(), profile);
    }

    public ServiceCall<Void> updateProfile(String dialogId, Integer clientId, Map<String, String> profile) {
        Validator.isTrue((dialogId != null && !dialogId.isEmpty() ? 1 : 0) != 0, (String)"dialogId cannot be null or empty");
        Validator.isTrue((profile != null && !profile.isEmpty() ? 1 : 0) != 0, (String)"profile cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        if (clientId != null) {
            contentJson.addProperty(CLIENT_ID, (Number)clientId);
        }
        contentJson.add(NAME_VALUES, GSON.toJsonTree(this.toNameValue(profile)));
        Request request = RequestBuilder.put((String)String.format(PATH_PROFILE, dialogId)).bodyJson(contentJson).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }
}

