/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.ipa.callgraph.CAstCallGraphUtil;
import com.ibm.wala.cast.js.html.IHtmlParser;
import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.test.ExtractingToPredictableFileNames;
import com.ibm.wala.cast.js.test.TestJSCallGraphShape;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import java.net.URL;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class TestSimplePageCallGraphShape
extends TestJSCallGraphShape {
    private ExtractingToPredictableFileNames predictable;
    private static final Object[][] assertionsForPage1 = new Object[][]{{ROOT, new String[]{"page1.html"}}, {"page1.html", new String[]{"page1.html/__WINDOW_MAIN__"}}, {"page1.html/__WINDOW_MAIN__", new String[]{"prologue.js/String_prototype_substring", "prologue.js/String_prototype_indexOf", "preamble.js/DOMDocument/Document_prototype_write", "prologue.js/encodeURI"}}};
    private static final Object[][] assertionsForPage2 = new Object[][]{{ROOT, new String[]{"page2.html"}}, {"page2.html", new String[]{"page2.html/__WINDOW_MAIN__"}}};
    private static final Object[][] assertionsForPage11 = new Object[][]{{ROOT, new String[]{"page11.html"}}, {"page11.html", new String[]{"page11.html/__WINDOW_MAIN__"}}, {"page11.html/__WINDOW_MAIN__", new String[]{"preamble.js/DOMDocument/Document_prototype_createElement", "preamble.js/DOMNode/Node_prototype_appendChild", "preamble.js/DOMElement/Element_prototype_setAttribute"}}};
    private static final Object[][] assertionsForPage11b = new Object[][]{{ROOT, new String[]{"page11b.html"}}, {"page11b.html", new String[]{"page11b.html/__WINDOW_MAIN__"}}, {"page11b.html/__WINDOW_MAIN__", new String[]{"preamble.js/DOMDocument/Document_prototype_createElement", "preamble.js/DOMNode/Node_prototype_appendChild", "preamble.js/DOMElement/Element_prototype_setAttribute"}}};
    private static final Object[][] assertionsForPage12 = new Object[][]{{ROOT, new String[]{"page12.html"}}, {"page12.html", new String[]{"page12.html/__WINDOW_MAIN__"}}, {"page12.html/__WINDOW_MAIN__", new String[]{"page12.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/button_onclick"}}, {"page12.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/button_onclick", new String[]{"page12.html/__WINDOW_MAIN__/callXHR"}}, {"page12.html/__WINDOW_MAIN__/callXHR", new String[]{"preamble.js/DOMDocument/Document_prototype_getElementById", "preamble.js/XMLHttpRequest/xhr_open", "preamble.js/XMLHttpRequest/xhr_send"}}, {"preamble.js/XMLHttpRequest/xhr_open", new String[]{"preamble.js/XMLHttpRequest/xhr_orsc_handler"}}, {"preamble.js/XMLHttpRequest/xhr_send", new String[]{"preamble.js/XMLHttpRequest/xhr_orsc_handler"}}, {"preamble.js/XMLHttpRequest/xhr_orsc_handler", new String[]{"page12.html/__WINDOW_MAIN__/handler"}}};
    private static final Object[][] assertionsForPage13 = new Object[][]{{ROOT, new String[]{"page13.html"}}, {"page13.html", new String[]{"page13.html/__WINDOW_MAIN__"}}, {"page13.html/__WINDOW_MAIN__", new String[]{"page13.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/button_onclick"}}, {"page13.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/button_onclick", new String[]{"page13.html/__WINDOW_MAIN__/callXHR"}}, {"page13.html/__WINDOW_MAIN__/callXHR", new String[]{"preamble.js/DOMDocument/Document_prototype_getElementById", "preamble.js/XMLHttpRequest/xhr_open", "preamble.js/XMLHttpRequest/xhr_setRequestHeader", "preamble.js/XMLHttpRequest/xhr_send"}}, {"preamble.js/XMLHttpRequest/xhr_open", new String[]{"preamble.js/XMLHttpRequest/xhr_orsc_handler"}}, {"preamble.js/XMLHttpRequest/xhr_send", new String[]{"preamble.js/XMLHttpRequest/xhr_orsc_handler"}}, {"preamble.js/XMLHttpRequest/xhr_orsc_handler", new String[]{"page13.html/__WINDOW_MAIN__/handler"}}};
    private static final Object[][] assertionsForPage15 = new Object[][]{{ROOT, new String[]{"page15.html"}}, {"page15.html", new String[]{"page15.html/__WINDOW_MAIN__"}}, {"page15.html/__WINDOW_MAIN__", new String[]{"page15.html/__WINDOW_MAIN__/make_node0/make_node3/body_onload"}}, {"page15.html/__WINDOW_MAIN__/make_node0/make_node3/body_onload", new String[]{"page15.html/__WINDOW_MAIN__/changeUrls"}}};
    private static final Object[][] assertionsForPage16 = new Object[][]{{ROOT, new String[]{"page16.html"}}, {"page16.html", new String[]{"page16.html/__WINDOW_MAIN__"}}, {"page16.html/__WINDOW_MAIN__", new String[]{"page16.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/a_onclick"}}, {"page16.html/__WINDOW_MAIN__/make_node0/make_node3/make_node4/a_onclick", new String[]{"page16.html/__WINDOW_MAIN__/changeUrls"}}};
    private static final Object[][] assertionsForPage17 = new Object[][]{{ROOT, new String[]{"page17.html"}}, {"page17.html", new String[]{"page17.html/__WINDOW_MAIN__"}}, {"page17.html/__WINDOW_MAIN__", new String[]{"page17.html/__WINDOW_MAIN__/loadScript"}}, {"preamble.js", new String[]{"page17.html/__WINDOW_MAIN__/loadScript/_page17_handler"}}, {"page17.html/__WINDOW_MAIN__/loadScript/_page17_handler", new String[]{"page17.html/__WINDOW_MAIN__/callFunction"}}, {"page17.html/__WINDOW_MAIN__/callFunction", new String[]{"suffix:changeUrls"}}};
    private static final Object[][] assertionsForApolloExample = new Object[][]{{ROOT, new String[]{"apollo-example.html"}}, {"apollo-example.html", new String[]{"apollo-example.html/__WINDOW_MAIN__"}}, {"apollo-example.html/__WINDOW_MAIN__", new String[]{"apollo-example.html/__WINDOW_MAIN__/signon"}}, {"apollo-example.html/__WINDOW_MAIN__/signon", new String[]{"preamble.js/DOMWindow/window_open"}}};
    private static final Object[][] sourceAssertionsForList = new Object[][]{{"suffix:update_display", "list.html#2", 4, 13}, {"suffix:update_with_item", "list.html#2", 9, 11}, {"suffix:add_item", "list.html#2", 15, 20}, {"suffix:collection", "pages/collection.js", 2, 14}, {"suffix:collection_add", "pages/collection.js", 7, 13}, {"suffix:forall_elt", "pages/collection.js", 9, 12}, {"suffix:forall_base", "pages/collection.js", 4, 4}};
    private static final Object[][] assertionsForWindowx = new Object[][]{{ROOT, new String[]{"windowx.html"}}, {"windowx.html", new String[]{"windowx.html/__WINDOW_MAIN__"}}, {"windowx.html/__WINDOW_MAIN__", new String[]{"windowx.html/__WINDOW_MAIN__/_f2", "windowx.html/__WINDOW_MAIN__/_f4"}}, {"windowx.html/__WINDOW_MAIN__/_f2", new String[]{"windowx.html/__WINDOW_MAIN__/_f1"}}, {"windowx.html/__WINDOW_MAIN__/_f4", new String[]{"windowx.html/__WINDOW_MAIN__/_f3"}}};
    private static final Object[][] assertionsForWindowOnload = new Object[][]{{ROOT, new String[]{"windowonload.html"}}, {"windowonload.html", new String[]{"windowonload.html/__WINDOW_MAIN__"}}, {"windowonload.html/__WINDOW_MAIN__", new String[]{"windowonload.html/__WINDOW_MAIN__/onload_handler"}}};
    public static final Object[][] assertionsForSkeleton = new Object[][]{{ROOT, new String[]{"skeleton.html"}}, {"skeleton.html", new String[]{"skeleton.html/__WINDOW_MAIN__"}}, {"skeleton.html/__WINDOW_MAIN__", new String[]{"skeleton.html/__WINDOW_MAIN__/dollar"}}, {"skeleton.html/__WINDOW_MAIN__/dollar", new String[]{"skeleton.html/__WINDOW_MAIN__/bad_guy"}}, {"skeleton.html/__WINDOW_MAIN__/bad_guy", new String[]{"skeleton.html/__WINDOW_MAIN__/dollar"}}};
    public static final Object[][] assertionsForSkeleton2 = new Object[][]{{ROOT, new String[]{"skeleton2.html"}}, {"skeleton2.html", new String[]{"skeleton2.html/__WINDOW_MAIN__"}}, {"skeleton2.html/__WINDOW_MAIN__", new String[]{"skeleton2.html/__WINDOW_MAIN__/dollar"}}, {"skeleton2.html/__WINDOW_MAIN__/dollar", new String[]{"ctor:skeleton2.html/__WINDOW_MAIN__/dollar_init"}}, {"ctor:skeleton2.html/__WINDOW_MAIN__/dollar_init", new String[]{"skeleton2.html/__WINDOW_MAIN__/dollar_init"}}, {"skeleton2.html/__WINDOW_MAIN__/dollar_init", new String[]{"skeleton2.html/__WINDOW_MAIN__/bad_guy"}}, {"skeleton2.html/__WINDOW_MAIN__/bad_guy", new String[]{"skeleton2.html/__WINDOW_MAIN__/dollar"}}};

    protected abstract IHtmlParser getParser();

    @Before
    public void setUp() {
        this.predictable = new ExtractingToPredictableFileNames();
    }

    @After
    public void tearDown() {
        this.predictable.close();
    }

    @Test
    public void testPage1() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/page1.html");
        assert (url != null);
        System.err.println("url is " + url);
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage1);
    }

    @Test
    public void testPage2() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/page2.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage2);
    }

    @Test
    public void testCrawlPage11() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page11.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage11);
    }

    @Test
    public void testCrawlPage11b() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page11b.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage11b);
    }

    @Test
    public void testCrawlPage12() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page12.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage12);
    }

    @Test
    public void testCrawlPage13() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page13.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage13);
    }

    @Test
    public void testCrawlPage15() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page15.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage15);
    }

    @Test
    public void testCrawlPage16() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page16.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage16);
    }

    @Test
    public void testCrawlPage17() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/crawl/page17.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForPage17);
    }

    @Test
    public void testApolloExample() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/apollo-example.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForApolloExample);
    }

    @Test
    public void testNojs() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/nojs.html");
        JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
    }

    @Test
    public void testPage4() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/page4.html");
        JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
    }

    @Test
    public void testList() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/list.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
        this.verifySourceAssertions(CG, sourceAssertionsForList);
    }

    @Test
    public void testIframeTest2() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/iframeTest2.html");
        JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
    }

    @Test
    public void testWindowx() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/windowx.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForWindowx);
    }

    @Test
    public void testWindowOnload() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/windowonload.html");
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeHTMLCGBuilder((URL)url);
        CallGraph CG = builder.makeCallGraph(builder.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)builder.getCFAContextInterpreter(), (PointerAnalysis)builder.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForWindowOnload);
    }

    @Test
    public void testSkeleton() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/skeleton.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        this.verifyGraphAssertions(CG, assertionsForSkeleton);
    }

    @Test
    public void testSkeleton2() throws IllegalArgumentException, CancelException, WalaException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("pages/skeleton2.html");
        CallGraph CG = JSCallGraphBuilderUtil.makeHTMLCG((URL)url);
        System.err.println(CG);
        this.verifyGraphAssertions(CG, assertionsForSkeleton2);
    }
}

