/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.ipa.callgraph.CAstCallGraphUtil;
import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.ipa.callgraph.PropertyNameContextSelector;
import com.ibm.wala.cast.js.test.TestJSCallGraphShape;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.cast.util.test.TestCallGraphShape;
import com.ibm.wala.core.util.ProgressMaster;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.tests.util.SlowTests;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.NullProgressMonitor;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2List;
import java.io.IOException;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class TestSimpleCallGraphShape
extends TestJSCallGraphShape {
    protected static final Object[][] assertionsForArgs = new Object[][]{{ROOT, new String[]{"args.js"}}, {"args.js", new String[]{"args.js/a"}}, {"args.js/a", new String[]{"args.js/x", "args.js/y"}}};
    protected static final Object[][] assertionsForSimple = new Object[][]{{ROOT, new String[]{"simple.js"}}, {"simple.js", new String[]{"simple.js/bad", "simple.js/silly", "simple.js/fib", "simple.js/stranger", "simple.js/trivial", "simple.js/rubbish", "simple.js/weirder"}}, {"simple.js/trivial", new String[]{"simple.js/trivial/inc"}}, {"simple.js/rubbish", new String[]{"simple.js/weirder", "simple.js/stranger", "simple.js/rubbish"}}, {"simple.js/fib", new String[]{"simple.js/fib"}}, {"simple.js/weirder", new String[]{"prologue.js/Math_abs"}}};
    private static final Object[][] assertionsForObjects = new Object[][]{{ROOT, new String[]{"objects.js"}}, {"objects.js", new String[]{"objects.js/objects_are_fun", "objects.js/other", "objects.js/something"}}, {"objects.js/other", new String[]{"objects.js/something", "objects.js/objects_are_fun/nothing"}}, {"objects.js/objects_are_fun", new String[]{"objects.js/other", "objects.js/whatever"}}};
    private static final Object[][] cfgAssertionsForInherit = new Object[][]{{"ctor:inherit.js/objectMasquerading/Rectangle", new int[][]{{1, 7}, {2}, {3, 7}, {4, 7}, {5, 6}, {7}, {7}}}, {"ctor:inherit.js/sharedClassObject/Rectangle", new int[][]{{1, 7}, {2}, {3, 7}, {4, 7}, {5, 6}, {7}, {7}}}};
    private static final Object[][] assertionsForInherit = new Object[][]{{ROOT, new String[]{"inherit.js"}}, {"inherit.js", new String[]{"inherit.js/objectMasquerading", "inherit.js/objectMasquerading/Rectangle/area", "inherit.js/Polygon/shape", "inherit.js/sharedClassObject", "inherit.js/sharedClassObject/Rectangle/area"}}, {"inherit.js/objectMasquerading", new String[]{"ctor:inherit.js/objectMasquerading/Rectangle"}}, {"ctor:inherit.js/objectMasquerading/Rectangle", new String[]{"inherit.js/objectMasquerading/Rectangle"}}, {"inherit.js/objectMasquerading/Rectangle", new String[]{"inherit.js/Polygon"}}, {"inherit.js/sharedClassObject", new String[]{"ctor:inherit.js/sharedClassObject/Rectangle"}}, {"ctor:inherit.js/sharedClassObject/Rectangle", new String[]{"inherit.js/sharedClassObject/Rectangle"}}};
    private static final Object[][] assertionsForNewfn = new Object[][]{{ROOT, new String[]{"newfn.js"}}, {"newfn.js", new String[]{"suffix:ctor$1/_fromctor", "suffix:ctor$2/_fromctor", "suffix:ctor$3/_fromctor"}}};
    private static final Object[][] assertionsForControlflow = new Object[][]{{ROOT, new String[]{"control-flow.js"}}, {"control-flow.js", new String[]{"control-flow.js/testSwitch", "control-flow.js/testDoWhile", "control-flow.js/testWhile", "control-flow.js/testFor", "control-flow.js/testReturn"}}};
    private static final Object[][] assertionsForMoreControlflow = new Object[][]{{ROOT, new String[]{"more-control-flow.js"}}, {"more-control-flow.js", new String[]{"more-control-flow.js/testSwitch", "more-control-flow.js/testIfConvertedSwitch", "more-control-flow.js/testDoWhile", "more-control-flow.js/testWhile", "more-control-flow.js/testFor", "more-control-flow.js/testReturn"}}};
    private static final Object[][] assertionsForForin = new Object[][]{{ROOT, new String[]{"forin.js"}}, {"forin.js", new String[]{"forin.js/testForIn"}}, {"forin.js/testForIn", new String[]{"forin.js/testForIn1", "forin.js/testForIn2"}}};
    private static final Object[][] assertionsForSimpleLexical = new Object[][]{{ROOT, new String[]{"simple-lexical.js"}}, {"simple-lexical.js", new String[]{"simple-lexical.js/outer"}}, {"simple-lexical.js/outer", new String[]{"simple-lexical.js/outer/indirect", "simple-lexical.js/outer/inner", "simple-lexical.js/outer/inner2", "simple-lexical.js/outer/inner3"}}, {"simple-lexical.js/outer/inner2", new String[]{"simple-lexical.js/outer/inner", "simple-lexical.js/outer/inner3"}}, {"simple-lexical.js/outer/indirect", new String[]{"simple-lexical.js/outer/inner", "simple-lexical.js/outer/inner3"}}};
    private static final Object[][] assertionsForLexicalMultiple = new Object[][]{{ROOT, new String[]{"lexical_multiple_calls.js"}}, {"suffix:lexical_multiple_calls.js", new String[]{"suffix:reachable1"}}, {"suffix:lexical_multiple_calls.js", new String[]{"suffix:reachable2"}}};
    private static final Object[][] assertionsForTry = new Object[][]{{ROOT, new String[]{"try.js"}}, {"try.js", new String[]{"try.js/tryCatch", "try.js/tryFinally", "try.js/tryCatchFinally"}}, {"try.js/tryCatch", new String[]{"try.js/targetOne", "try.js/targetTwo", "try.js/two"}}, {"try.js/tryFinally", new String[]{"try.js/targetOne", "try.js/targetTwo", "try.js/two"}}, {"try.js/tryCatchFinally", new String[]{"try.js/targetOne", "try.js/targetTwo", "try.js/three", "try.js/two"}}, {"try.js/tryCatchTwice", new String[]{"try.js/targetOne", "try.js/targetTwo", "try.js/three", "try.js/two"}}, {"try.js/testRet", new String[]{"try.js/three", "try.js/two"}}};
    private static final Object[][] assertionsForStringOp = new Object[][]{{ROOT, new String[]{"string-op.js"}}, {"string-op.js", new String[]{"string-op.js/getOp", "string-op.js/plusNum"}}};
    private static final Object[][] assertionsForUpward = new Object[][]{{ROOT, new String[]{"upward.js"}}, {"upward.js", new String[]{"upward.js/Obj/setit", "upward.js/Obj/getit", "upward.js/tester1", "upward.js/tester2"}}};
    private static final Object[][] assertionsForStringPrims = new Object[][]{{ROOT, new String[]{"string-prims.js"}}, {"string-prims.js", new String[]{"prologue.js/String_prototype_split", "prologue.js/String_prototype_toUpperCase"}}};
    private static final Object[][] assertionsForNested = new Object[][]{{ROOT, new String[]{"nested.js"}}, {"nested.js", new String[]{"nested.js/f", "nested.js/f/ff", "nested.js/f/ff/fff"}}};
    private static final Object[][] assertionsForInstanceof = new Object[][]{{ROOT, new String[]{"instanceof.js"}}};
    private static final Object[][] assertionsForMultivar = new Object[][]{{ROOT, new String[]{"multivar.js"}}, {"multivar.js", new String[]{"multivar.js/a", "multivar.js/bf", "multivar.js/c"}}};
    private static final Object[][] assertionsForPrototypeContamination = new Object[][]{{ROOT, new String[]{"prototype_contamination_bug.js"}}, {"suffix:test1", new String[]{"suffix:foo_of_A"}}, {"suffix:test2", new String[]{"suffix:foo_of_B"}}};
    private static final Object[][] assertionsForFunctionApply = new Object[][]{{ROOT, new String[]{"function_apply.js"}}, {"suffix:function_apply.js", new String[]{"suffix:theOne"}}, {"suffix:function_apply.js", new String[]{"suffix:theTwo"}}};
    private static final Object[][] assertionsForFunctionApply2 = new Object[][]{{ROOT, new String[]{"function_apply2.js"}}, {"suffix:function_apply2.js", new String[]{"suffix:theThree"}}};
    private static final Object[][] assertionsForFunctionApply3 = new Object[][]{{ROOT, new String[]{"function_apply3.js"}}, {"suffix:apply", new String[]{"suffix:foo"}}};
    private static final Object[][] assertionsForWrap1 = new Object[][]{{ROOT, new String[]{"wrap1.js"}}, {"suffix:wrap1.js", new String[]{"suffix:i_am_reachable"}}};
    private static final Object[][] assertionsForWrap2 = new Object[][]{{ROOT, new String[]{"wrap2.js"}}, {"suffix:wrap2.js", new String[]{"suffix:i_am_reachable"}}};
    private static final Object[][] assertionsForWrap3 = new Object[][]{{ROOT, new String[]{"wrap3.js"}}, {"suffix:wrap3.js", new String[]{"suffix:i_am_reachable"}}};
    private static final Object[][] assertionsForComplexCall = new Object[][]{{ROOT, new String[]{"complex_call.js"}}, {"suffix:call.js", new String[]{"suffix:f3"}}};
    private static final Object[][] assertionsForGlobalObj = new Object[][]{{ROOT, new String[]{"global_object.js"}}, {"suffix:global_object.js", new String[]{"suffix:biz"}}};
    private static final Object[][] assertionsForGlobalObj2 = new Object[][]{{ROOT, new String[]{"global_object2.js"}}, {"suffix:global_object2.js", new String[]{"suffix:foo"}}};
    private static final Object[][] assertionsForReturnThis = new Object[][]{{ROOT, new String[]{"return_this.js"}}, {"suffix:return_this.js", new String[]{"suffix:foo"}}, {"suffix:return_this.js", new String[]{"suffix:bar"}}};
    private static final Object[][] assertionsForReturnThis2 = new Object[][]{{ROOT, new String[]{"return_this2.js"}}, {"suffix:return_this2.js", new String[]{"suffix:A"}}, {"suffix:return_this2.js", new String[]{"suffix:foo"}}, {"suffix:return_this2.js", new String[]{"suffix:test1"}}, {"suffix:return_this2.js", new String[]{"suffix:test2"}}, {"suffix:test1", new String[]{"suffix:bar1"}}, {"suffix:test2", new String[]{"suffix:bar2"}}};
    private static final Object[][] assertionsForArguments = new Object[][]{{ROOT, new String[]{"arguments.js"}}, {"suffix:arguments.js", new String[]{"suffix:f"}}, {"suffix:f", new String[]{"!suffix:g1", "!suffix:g2", "suffix:g3"}}};
    private static final Object[][] assertionsForFunctionIsAFunction = new Object[][]{{ROOT, new String[]{"Function_is_a_function.js"}}, {"suffix:Function_is_a_function.js", new String[]{"suffix:Function_prototype_call"}}};
    private static final Object[][] assertionsForLexicalBroken = new Object[][]{{ROOT, new String[]{"lexical_broken.js"}}, {"suffix:lexical_broken.js", new String[]{"suffix:f"}}, {"suffix:f", new String[]{"suffix:g"}}};
    private static final Object[][] assertionsForScopingOverwriteFunction = new Object[][]{{ROOT, new String[]{"scoping_test.js"}}, {"suffix:scoping_test.js", new String[]{"suffix:i_am_reachable"}}};
    private static final Object[][] assertionsForNestedParamAssign = new Object[][]{{ROOT, new String[]{"nested_assign_to_param.js"}}, {"suffix:nested_assign_to_param.js", new String[]{"suffix:i_am_reachable"}}};
    private static final Object[][] assertionsForDispatch = new Object[][]{{ROOT, new String[]{"dispatch.js"}}, {"dispatch.js", new String[]{"dispatch.js/left_outer", "dispatch.js/right_outer"}}, {"dispatch.js/left_outer", new String[]{"dispatch.js/left_inner"}}, {"dispatch.js/right_outer", new String[]{"dispatch.js/right_inner"}}};
    private static final Object[][] assertionsForDispatchSameTarget = new Object[][]{{ROOT, new String[]{"dispatch_same_target.js"}}, {"dispatch_same_target.js/f3", new String[]{"dispatch_same_target.js/f4"}}};
    private static final Object[][] assertionsForForInPrototype = new Object[][]{{ROOT, new String[]{"for_in_prototype.js"}}, {"for_in_prototype.js", new String[]{"suffix:A", "suffix:reachable", "suffix:also_reachable"}}};
    private static final Object[][] assertionsForArrayIndexConv = new Object[][]{{ROOT, new String[]{"array_index_conv.js"}}, {"array_index_conv.js", new String[]{"suffix:reachable1", "suffix:reachable2", "suffix:reachable3", "suffix:reachable4"}}};
    private static final Object[][] assertionsForArrayIndexConv2 = new Object[][]{{ROOT, new String[]{"array_index_conv2.js"}}, {"array_index_conv2.js", new String[]{"suffix:invokeOnA"}}, {"suffix:invokeOnA", new String[]{"suffix:reachable", "suffix:also_reachable", "suffix:reachable_too"}}};
    private static final Object[][] assertionsForDateProperty = new Object[][]{{ROOT, new String[]{"date-property.js"}}, {"date-property.js", new String[]{"suffix:_fun"}}};
    private static final Object[][] assertionsForDeadCode = new Object[][]{{ROOT, new String[]{"dead.js"}}, {"dead.js", new String[]{"suffix:twoReturns"}}};
    private static final Object[][] assertionsForShadow = new Object[][]{{ROOT, new String[]{"shadow_test.js"}}, {"shadow_test.js", new String[]{"shadow_test.js/test"}}, {"shadow_test.js/test", new String[]{"shadow_test.js/bad"}}, {"shadow_test.js/test", new String[]{"shadow_test.js/global_bad"}}};
    private static final Object[][] assertionsForExtend = new Object[][]{{ROOT, new String[]{"extend.js"}}, {"extend.js", new String[]{"suffix:bar", "!suffix:foo"}}};
    private static final Object[][] assertionsForLoops = new Object[][]{{ROOT, new String[]{"loops.js"}}, {"loops.js", new String[]{"loops.js/three", "loops.js/four"}}};
    private static final Object[][] assertionsForPrimitiveStrings = new Object[][]{{ROOT, new String[]{"primitive_strings.js"}}, {"primitive_strings.js", new String[]{"primitive_strings.js/f1", "primitive_strings.js/f1"}}, {"primitive_strings.js/f2", new String[]{"prologue.js/String_prototype_concat"}}, {"primitive_strings.js/f1", new String[]{"prologue.js/String_prototype_concat"}}};
    Object[][] renamingAssertions = new Object[][]{{"rename-example.js/f", new TestCallGraphShape.Name[]{new TestCallGraphShape.Name(9, 7, "x"), new TestCallGraphShape.Name(9, 7, "y")}}, {"rename-example.js/ff", new TestCallGraphShape.Name[]{new TestCallGraphShape.Name(11, 10, "x"), new TestCallGraphShape.Name(11, 10, "y"), new TestCallGraphShape.Name(11, 10, "z")}}};
    private static final Object[][] assertionsForComplexFinally = new Object[][]{{ROOT, new String[]{"complex_finally.js"}}, {"complex_finally.js", new String[]{"complex_finally.js/e"}}, {"complex_finally.js/e", new String[]{"complex_finally.js/base", "complex_finally.js/bad", "complex_finally.js/good", "complex_finally.js/oo1", "complex_finally.js/oo2"}}};

    @Test
    public void testArgs() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"args.js");
        this.verifyGraphAssertions(CG, assertionsForArgs);
    }

    @Test
    public void testSimple() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"simple.js");
        this.verifyGraphAssertions(CG, assertionsForSimple);
    }

    @Test
    public void testObjects() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"objects.js");
        this.verifyGraphAssertions(CG, assertionsForObjects);
    }

    @Test
    public void testInherit() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"inherit.js");
        this.verifyGraphAssertions(CG, assertionsForInherit);
        this.verifyCFGAssertions(CG, cfgAssertionsForInherit);
    }

    @Test
    public void testNewfn() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"newfn.js");
        this.verifyGraphAssertions(CG, assertionsForNewfn);
    }

    @Test
    public void testControlflow() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"control-flow.js");
        this.verifyGraphAssertions(CG, assertionsForControlflow);
    }

    @Test
    public void testMoreControlflow() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"more-control-flow.js");
        this.verifyGraphAssertions(CG, assertionsForMoreControlflow);
    }

    @Test
    public void testForin() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"forin.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForForin);
    }

    @Test
    public void testSimpleLexical() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"simple-lexical.js");
        this.verifyGraphAssertions(CG, assertionsForSimpleLexical);
    }

    @Test
    public void testRecursiveLexical() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"recursive_lexical.js");
    }

    @Test
    public void testLexicalMultiple() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"lexical_multiple_calls.js");
        this.verifyGraphAssertions(CG, assertionsForLexicalMultiple);
    }

    @Test
    public void testTry() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"try.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean x = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.AVOID_DUMP = false;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)((SSAContextInterpreter)B.getContextInterpreter()), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = x;
        this.verifyGraphAssertions(CG, assertionsForTry);
    }

    @Test
    public void testStringOp() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"string-op.js");
        B.getOptions().setTraceStringConstants(true);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForStringOp);
    }

    @Test
    public void testUpward() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"upward.js");
        this.verifyGraphAssertions(CG, assertionsForUpward);
    }

    @Test
    public void testStringPrims() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"string-prims.js");
        B.getOptions().setTraceStringConstants(true);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForStringPrims);
    }

    @Test
    public void testNested() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"nested.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForNested);
    }

    @Test
    public void testInstanceof() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"instanceof.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForInstanceof);
    }

    @Test
    public void testCrash1() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"crash1.js");
        this.verifyGraphAssertions(CG, null);
    }

    @Test
    public void testCrash2() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"crash2.js");
        this.verifyGraphAssertions(CG, null);
    }

    @Test
    public void testLexicalCtor() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"lexical-ctor.js");
        this.verifyGraphAssertions(CG, null);
    }

    @Test
    public void testMultivar() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"multivar.js");
        this.verifyGraphAssertions(CG, assertionsForMultivar);
    }

    @Test
    public void testProtoypeContamination() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"prototype_contamination_bug.js");
        this.verifyGraphAssertions(CG, assertionsForPrototypeContamination);
        this.verifyNoEdges(CG, "suffix:test1", "suffix:foo_of_B");
        this.verifyNoEdges(CG, "suffix:test2", "suffix:foo_of_A");
    }

    @Test
    @Category(value={SlowTests.class})
    public void testStackOverflowOnSsaConversionBug() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"stack_overflow_on_ssa_conversion.js");
    }

    @Test
    public void testExtJSSwitch() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"extjs_switch.js");
    }

    @Test
    public void testFunctionDotCall() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph cg = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"function_call.js");
        for (CGNode n : cg) {
            if (!n.getMethod().getName().toString().equals("call4")) continue;
            Assert.assertEquals((long)2L, (long)cg.getSuccNodeCount((Object)n));
            Iterator2List succs = Iterator2Collection.toList((Iterator)cg.getSuccNodes((Object)n));
            Assert.assertEquals((Object)"[Node: <Code body of function Lfunction_call.js/foo> Context: Everywhere, Node: <Code body of function Lfunction_call.js/bar> Context: Everywhere]", (Object)succs.toString());
        }
    }

    @Test
    public void testFunctionDotApply() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"function_apply.js");
        this.verifyGraphAssertions(CG, assertionsForFunctionApply);
    }

    @Test
    public void testFunctionDotApply2() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"function_apply2.js");
        this.verifyGraphAssertions(CG, assertionsForFunctionApply2);
    }

    @Test
    public void testFunctionDotApply3() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"function_apply3.js");
        this.verifyGraphAssertions(CG, assertionsForFunctionApply3);
    }

    @Test
    public void testWrap1() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"wrap1.js");
        this.verifyGraphAssertions(CG, assertionsForWrap1);
    }

    @Test
    public void testWrap2() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"wrap2.js");
        this.verifyGraphAssertions(CG, assertionsForWrap2);
    }

    @Test
    public void testWrap3() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"wrap3.js");
        this.verifyGraphAssertions(CG, assertionsForWrap3);
    }

    @Test
    public void testComplexCall() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"complex_call.js");
        for (CGNode nd : CG) {
            System.out.println(nd);
        }
        this.verifyGraphAssertions(CG, assertionsForComplexCall);
    }

    @Test
    public void testGlobalObjPassing() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"global_object.js");
        this.verifyGraphAssertions(CG, assertionsForGlobalObj);
    }

    @Test
    public void testGlobalObj2() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"global_object2.js");
        this.verifyGraphAssertions(CG, assertionsForGlobalObj2);
    }

    @Test
    public void testReturnThis() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"return_this.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForReturnThis);
    }

    @Test
    public void testReturnThis2() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"return_this2.js");
        this.verifyGraphAssertions(CG, assertionsForReturnThis2);
    }

    @Test
    public void testArguments() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"arguments.js");
        this.verifyGraphAssertions(CG, assertionsForArguments);
    }

    @Test
    public void testFunctionIsAFunction() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"Function_is_a_function.js");
        this.verifyGraphAssertions(CG, assertionsForFunctionIsAFunction);
    }

    @Test
    public void testLexicalBroken() throws IOException, IllegalArgumentException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"lexical_broken.js");
        this.verifyGraphAssertions(CG, assertionsForLexicalBroken);
    }

    @Test
    public void testDeadPhi() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"dead_phi.js");
    }

    @Test
    public void testScopingOverwriteFunction() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"scoping_test.js");
        this.verifyGraphAssertions(CG, assertionsForScopingOverwriteFunction);
    }

    @Test
    public void testNestedAssignToParam() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph CG = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"nested_assign_to_param.js");
        this.verifyGraphAssertions(CG, assertionsForNestedParamAssign);
    }

    @Test
    public void testDispatch() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"dispatch.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        this.verifyGraphAssertions(CG, assertionsForDispatch);
    }

    @Test
    public void testDispatchSameTarget() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"dispatch_same_target.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForDispatchSameTarget);
    }

    @Test
    public void testForInPrototype() throws IllegalArgumentException, IOException, CancelException, WalaException {
        CallGraph cg = JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"for_in_prototype.js");
        this.verifyGraphAssertions(cg, assertionsForForInPrototype);
    }

    @Test
    public void testArrayIndexConv() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder b = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"array_index_conv.js");
        CallGraph cg = b.makeCallGraph(b.getOptions());
        this.verifyGraphAssertions(cg, assertionsForArrayIndexConv);
    }

    @Test
    public void testArrayIndexConv2() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder b = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"array_index_conv2.js");
        b.setContextSelector((ContextSelector)new PropertyNameContextSelector(b.getAnalysisCache(), b.getContextSelector()));
        CallGraph cg = b.makeCallGraph(b.getOptions());
        this.verifyGraphAssertions(cg, assertionsForArrayIndexConv2);
    }

    @Test
    public void testDateAsProperty() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"date-property.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForDateProperty);
    }

    @Test
    public void testDeadCode() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"dead.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForDeadCode);
    }

    @Test
    public void testShadow() throws IOException, WalaException, IllegalArgumentException, CancelException {
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"shadow_test.js");
        CallGraph cg = builder.makeCallGraph(builder.getOptions());
        this.verifyGraphAssertions(cg, assertionsForShadow);
    }

    @Test
    public void testExtend() throws IOException, WalaException, IllegalArgumentException, CancelException {
        JSCFABuilder builder = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"extend.js");
        CallGraph cg = builder.makeCallGraph(builder.getOptions());
        this.verifyGraphAssertions(cg, assertionsForExtend);
    }

    @Test
    public void testDeadCatch() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"dead_catch.js");
    }

    @Test
    public void testUglyLoopCrash() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCallGraphBuilderUtil.makeScriptCG((String)"tests", (String)"ssa-crash.js");
    }

    @Test
    public void testTryFinallyCrash() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"try-finally-crash.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }

    @Test(expected=CallGraphBuilderCancelException.class)
    @Category(value={SlowTests.class})
    public void testManyStrings() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"many-strings.js");
        B.getOptions().setTraceStringConstants(true);
        MonitorUtil.IProgressMonitor monitor = ProgressMaster.make((MonitorUtil.IProgressMonitor)new NullProgressMonitor(), (int)10000, (boolean)false);
        monitor.beginTask("build CG", 1);
        CallGraph CG = B.makeCallGraph(B.getOptions(), monitor);
        monitor.done();
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
    }

    @Test
    public void testTutorialExample() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"tutorial-example.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
    }

    @Ignore(value="need to fix this.  bug from Sukyoung's group")
    @Test
    public void testLoops() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"loops.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean x = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.AVOID_DUMP = false;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = x;
        this.verifyGraphAssertions(CG, assertionsForLoops);
    }

    @Ignore(value="need to fix this.  bug from Sukyoung's group")
    @Test
    public void testPrimitiveStrings() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"primitive_strings.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean x = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.AVOID_DUMP = false;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = x;
        this.verifyGraphAssertions(CG, assertionsForPrimitiveStrings);
    }

    @Test
    public void testRenaming() throws IOException, WalaException, IllegalArgumentException, CancelException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"rename-example.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyNameAssertions(CG, this.renamingAssertions);
    }

    @Test
    public void testLexicalCatch() throws IOException, WalaException, IllegalArgumentException, CancelException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"lexical_catch.js");
        B.makeCallGraph(B.getOptions());
    }

    @Test
    public void testThrowCrash() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"badthrow.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }

    @Test
    public void testNrWrapperCrash() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"nrwrapper.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }

    @Test
    public void testFinallyCrash() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"finallycrash.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }

    @Test
    public void testForInExpr() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"for_in_expr.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }

    @Test
    public void testComplexFinally() throws IllegalArgumentException, IOException, CancelException, WalaException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"complex_finally.js");
        CallGraph CG = B.makeCallGraph(B.getOptions());
        this.verifyGraphAssertions(CG, assertionsForComplexFinally);
        boolean save = CAstCallGraphUtil.AVOID_DUMP;
        CAstCallGraphUtil.dumpCG((SSAContextInterpreter)B.getCFAContextInterpreter(), (PointerAnalysis)B.getPointerAnalysis(), (CallGraph)CG);
        CAstCallGraphUtil.AVOID_DUMP = save;
    }
}

