/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.ipa.lexical.LexicalModRef;
import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestLexicalModRef {
    @Test
    public void testSimpleLexical() throws IOException, IllegalArgumentException, CancelException, WalaException {
        JSCFABuilder b = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)"simple-lexical.js");
        CallGraph CG = b.makeCallGraph(b.getOptions());
        LexicalModRef lexAccesses = LexicalModRef.make((CallGraph)CG, (PointerAnalysis)b.getPointerAnalysis());
        Map readResult = lexAccesses.computeLexicalRef();
        Map writeResult = lexAccesses.computeLexicalMod();
        for (Map.Entry entry : readResult.entrySet()) {
            OrdinalSet readVars;
            CGNode n = (CGNode)entry.getKey();
            if (n.toString().contains("Node: <Code body of function Ltests/simple-lexical.js/outer/inner>")) {
                readVars = (OrdinalSet)entry.getValue();
                Assert.assertEquals((long)2L, (long)readVars.size());
                Assert.assertEquals((Object)"[[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,x], [Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,z]]", (Object)readVars.toString());
                OrdinalSet writtenVars = (OrdinalSet)writeResult.get(n);
                Assert.assertEquals((long)2L, (long)writtenVars.size());
                Assert.assertEquals((Object)"[[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,x], [Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,z]]", (Object)writtenVars.toString());
            }
            if (!n.toString().contains("Node: <Code body of function Ltests/simple-lexical.js/outer/inner2>")) continue;
            readVars = (OrdinalSet)entry.getValue();
            Assert.assertEquals((long)4L, (long)readVars.size());
            for (Pair rv : readVars) {
                Assert.assertTrue((String)rv.toString(), ("[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,x]".equals(rv.toString()) || "[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,inner3]".equals(rv.toString()) || "[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,innerName]".equals(rv.toString()) || "[Node: <Code body of function Ltests/simple-lexical.js/outer> Context: Everywhere,z]".equals(rv.toString()) ? 1 : 0) != 0);
            }
        }
    }
}

