/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.test;

import com.ibm.wala.cast.js.ipa.callgraph.JSCFABuilder;
import com.ibm.wala.cast.js.ipa.modref.JavaScriptModRef;
import com.ibm.wala.cast.js.test.TestJSCallGraphShape;
import com.ibm.wala.cast.js.util.JSCallGraphBuilderUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.SlicerUtil;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestJavaScriptSlicer
extends TestJSCallGraphShape {
    @Test
    public void testSimpleData() throws IOException, WalaException, IllegalArgumentException, CancelException {
        Collection<Statement> result = this.slice("slice1.js", Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.NONE);
        for (Statement r : result) {
            System.err.println(r);
        }
        Assert.assertEquals((long)0L, (long)SlicerUtil.countConditionals(result));
    }

    @Test
    public void testSimpleAll() throws IOException, WalaException, IllegalArgumentException, CancelException {
        Collection<Statement> result = this.slice("slice1.js", Slicer.DataDependenceOptions.FULL, Slicer.ControlDependenceOptions.FULL);
        for (Statement r : result) {
            System.err.println(r);
        }
        Assert.assertEquals((long)2L, (long)SlicerUtil.countConditionals(result));
    }

    @Test
    public void testSimpleControl() throws IOException, WalaException, IllegalArgumentException, CancelException {
        Collection<Statement> result = this.slice("slice1.js", Slicer.DataDependenceOptions.NONE, Slicer.ControlDependenceOptions.FULL);
        for (Statement r : result) {
            System.err.println(r);
        }
        Assert.assertEquals((long)1L, (long)SlicerUtil.countConditionals(result));
    }

    private Collection<Statement> slice(String file, Slicer.DataDependenceOptions data, Slicer.ControlDependenceOptions ctrl) throws IOException, WalaException, CancelException {
        JSCFABuilder B = JSCallGraphBuilderUtil.makeScriptCGBuilder((String)"tests", (String)file);
        CallGraph CG = B.makeCallGraph(B.getOptions());
        SDG sdg = new SDG(CG, B.getPointerAnalysis(), (ModRef)new JavaScriptModRef(), data, ctrl);
        Collection<Statement> ss = this.findTargetStatement(CG);
        Collection result = Slicer.computeBackwardSlice((SDG)sdg, ss);
        return result;
    }

    private Collection<Statement> findTargetStatement(CallGraph CG) {
        HashSet ss = HashSetFactory.make();
        for (CGNode n : this.getNodes(CG, "suffix:_slice_target_fn")) {
            for (CGNode caller : Iterator2Iterable.make((Iterator)CG.getPredNodes((Object)n))) {
                for (CallSiteReference site : Iterator2Iterable.make((Iterator)CG.getPossibleSites(caller, n))) {
                    caller.getIR().getCallInstructionIndices(site).foreach(x -> ss.add(new NormalStatement(caller, x)));
                }
            }
        }
        return ss;
    }
}

