/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.clientlibrary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Util {
    public static <T> T uncheckedCast(Object obj) {
        return (T)obj;
    }

    public static byte[] compress(Serializable object) {
        ByteArrayOutputStream baos;
        block7: {
            baos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gzipOut = null;
                ObjectOutputStream objectOut = null;
                try {
                    try {
                        gzipOut = new GZIPOutputStream(baos);
                        objectOut = new ObjectOutputStream(gzipOut);
                        objectOut.writeObject(object);
                    }
                    catch (Exception e) {
                        Util.describeException(e, "Exception in Util.compress");
                        objectOut.close();
                        gzipOut.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    objectOut.close();
                    gzipOut.close();
                    throw throwable;
                }
                objectOut.close();
                gzipOut.close();
            }
            catch (Exception e) {
                Util.describeException(e, "Exception in Util.compress");
            }
        }
        return baos.toByteArray();
    }

    public static <T> T decompress(byte[] bytes) {
        T object;
        block7: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            object = null;
            try {
                GZIPInputStream gzipIn = null;
                ObjectInputStream objectIn = null;
                try {
                    try {
                        gzipIn = new GZIPInputStream(bais);
                        objectIn = new ObjectInputStream(gzipIn);
                        object = Util.uncheckedCast(objectIn.readObject());
                    }
                    catch (Exception e) {
                        Util.describeException(e, "Exception in Util.decompress");
                        objectIn.close();
                        gzipIn.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    objectIn.close();
                    gzipIn.close();
                    throw throwable;
                }
                objectIn.close();
                gzipIn.close();
            }
            catch (Exception e) {
                Util.describeException(e, "Exception in Util.decompress");
            }
        }
        return object;
    }

    public static void describeException(Exception e, String message) {
        System.out.println(message);
        System.out.println(e.getMessage());
        e.printStackTrace();
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }
}

