/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.clientlibrary;

import com.ibm.storage.clientlibrary.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;

public class Serializer {
    public static <T> T deserializeFromByteArray(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        T r = null;
        try {
            try {
                in = new ObjectInputStream(bis);
                r = Util.uncheckedCast(in.readObject());
            }
            catch (IOException i) {
                System.out.println("Exception in Serializer.deserializeFromByteArray  ,  " + i.getMessage());
                i.printStackTrace();
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            catch (ClassNotFoundException c) {
                System.out.println("Serializer.deserializeFromByteArray: class not found");
                c.printStackTrace();
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return r;
    }

    public static <T> byte[] serializeToByteArray(T r) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        byte[] bytes = null;
        try {
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(r);
                bytes = bos.toByteArray();
            }
            catch (IOException ex) {
                System.out.println("Exception in Serializer.serializeToByteArray  ,  " + ex.getMessage() + " " + ex.getStackTrace());
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bytes;
    }

    public static String deserializeToString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }

    public static byte[] serializeString(String string, Charset charset) {
        return string == null ? null : string.getBytes(charset);
    }
}

