/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.clientlibrary;

import com.ibm.storage.clientlibrary.CacheEntry;
import com.ibm.storage.clientlibrary.CacheWithLifetimes;
import com.ibm.storage.clientlibrary.RedisCacheStats;
import com.ibm.storage.clientlibrary.Serializer;
import com.ibm.storage.clientlibrary.Util;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;

public class RedisCache<K, V>
implements CacheWithLifetimes<K, V> {
    private Jedis cache;
    private long defaultLifetime;
    private static final String DEFAULT_CHAR_SET = "UTF8";

    public RedisCache(String host, long defaultLifespan) {
        this.cache = new Jedis(host);
        this.defaultLifetime = defaultLifespan;
    }

    public RedisCache(String host, int port, long defaultLifespan) {
        this.cache = new Jedis(host, port);
        this.defaultLifetime = defaultLifespan;
    }

    public RedisCache(String host, int port, int timeout, long defaultLifespan) {
        this.cache = new Jedis(host, port, timeout);
        this.defaultLifetime = defaultLifespan;
    }

    public RedisCache(Jedis jedisCache, long defaultLifespan) {
        this.cache = jedisCache;
        this.defaultLifetime = defaultLifespan;
    }

    @Override
    public void clear() {
        this.cache.flushDB();
    }

    public void close() {
        this.cache.close();
    }

    @Override
    public void delete(K key) {
        this.cache.del(Serializer.serializeToByteArray(key));
    }

    @Override
    public void deleteAll(List<K> keys) {
        for (K key : keys) {
            this.cache.del(Serializer.serializeToByteArray(key));
        }
    }

    public String flushAll() {
        return this.cache.flushAll();
    }

    @Override
    public V get(K key) {
        CacheEntry<V> cacheEntry = this.getCacheEntry(key);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.getExpirationTime() >= Util.getTime()) {
            return cacheEntry.getValue();
        }
        return null;
    }

    @Override
    public Map<K, V> getAll(List<K> keys) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            hashMap.put(key, value);
        }
        return hashMap;
    }

    @Override
    public CacheEntry<V> getCacheEntry(K key) {
        byte[] rawValue = this.cache.get(Serializer.serializeToByteArray(key));
        if (rawValue == null) {
            return null;
        }
        return (CacheEntry)Serializer.deserializeFromByteArray(rawValue);
    }

    @Override
    public RedisCacheStats getStatistics() {
        return new RedisCacheStats(this.cache.info());
    }

    public String printCacheEntry(K key) {
        String result = "lookup: CacheEntry value for key: " + key + "\n";
        CacheEntry<V> cacheEntry = this.getCacheEntry(key);
        result = cacheEntry == null ? String.valueOf(result) + "Key " + key + " not in cache" + "\n" : String.valueOf(result) + cacheEntry.toString();
        return result;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.defaultLifetime);
    }

    @Override
    public void put(K key, V value, long lifetime) {
        CacheEntry<V> cacheEntry = new CacheEntry<V>(value, lifetime + Util.getTime());
        this.put(key, cacheEntry);
    }

    @Override
    private void put(K key, CacheEntry<V> cacheEntry) {
        byte[] array1 = Serializer.serializeToByteArray(key);
        byte[] array2 = Serializer.serializeToByteArray(cacheEntry);
        this.cache.set(array1, array2);
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.putAll(map, this.defaultLifetime);
    }

    @Override
    public void putAll(Map<K, V> map, long lifetime) {
        long expirationTime = Util.getTime() + lifetime;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CacheEntry<V> cacheEntry = new CacheEntry<V>(entry.getValue(), expirationTime);
            this.put(entry.getKey(), cacheEntry);
        }
    }

    @Override
    public long size() {
        return this.cache.dbSize();
    }

    public String toString(String charset) {
        String result = "\nContents of Entire Cache\n\n";
        Set keys = this.cache.keys(Serializer.serializeString("*", Charset.forName(charset)));
        for (byte[] key : keys) {
            CacheEntry cacheEntry;
            String keyString = (String)Serializer.deserializeFromByteArray(key);
            result = String.valueOf(result) + "Key: " + keyString + "\n";
            byte[] rawValue = this.cache.get(key);
            result = rawValue == null ? String.valueOf(result) + "No value found in cache for keyString " + keyString + "\n\n" : ((cacheEntry = (CacheEntry)Serializer.deserializeFromByteArray(rawValue)) == null ? String.valueOf(result) + "CacheEntry is null for keyString " + keyString + "\n\n" : String.valueOf(result) + cacheEntry.toString() + "\n\n");
        }
        result = String.valueOf(result) + "Cache size is: " + this.size() + "\n";
        return result;
    }

    public String toString() {
        return this.toString(DEFAULT_CHAR_SET);
    }
}

