/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.clientlibrary;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.ibm.storage.clientlibrary.CacheEntry;
import com.ibm.storage.clientlibrary.CacheWithLifetimes;
import com.ibm.storage.clientlibrary.InProcessCacheStats;
import com.ibm.storage.clientlibrary.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class InProcessCache<K, V>
implements CacheWithLifetimes<K, V> {
    private LoadingCache<K, CacheEntry<V>> cache;
    private long defaultLifetime;

    public InProcessCache(long maxObjects, long defaultLifespan) {
        this.cache = CacheBuilder.newBuilder().maximumSize(maxObjects).build(new CacheLoader<K, CacheEntry<V>>(){

            public CacheEntry<V> load(K key) throws Exception {
                return null;
            }
        });
        this.defaultLifetime = defaultLifespan;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void delete(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public void deleteAll(List<K> keys) {
        this.cache.invalidateAll(keys);
    }

    @Override
    public V get(K key) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent(key);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.getExpirationTime() >= Util.getTime()) {
            return cacheEntry.getValue();
        }
        return null;
    }

    @Override
    public Map<K, V> getAll(List<K> keys) {
        ImmutableMap cacheMap = this.cache.getAllPresent(keys);
        HashMap hashMap = new HashMap();
        long currentTime = Util.getTime();
        for (Map.Entry entry : cacheMap.entrySet()) {
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            if (cacheEntry.getExpirationTime() < currentTime) continue;
            hashMap.put(entry.getKey(), cacheEntry.getValue());
        }
        return hashMap;
    }

    @Override
    public CacheEntry<V> getCacheEntry(K key) {
        return (CacheEntry)this.cache.getIfPresent(key);
    }

    @Override
    public InProcessCacheStats getStatistics() {
        return new InProcessCacheStats(this.cache.stats());
    }

    public String printCacheEntry(K key) {
        String result = "printCacheEntry: CacheEntry value for key: " + key + "\n";
        CacheEntry cacheEntry = (CacheEntry)this.cache.getIfPresent(key);
        result = cacheEntry == null ? String.valueOf(result) + "Key " + key + " not in cache\n" : String.valueOf(result) + cacheEntry.toString();
        return result;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.defaultLifetime);
    }

    @Override
    public void put(K key, V value, long lifetime) {
        CacheEntry<V> cacheEntry = new CacheEntry<V>(value, lifetime + Util.getTime());
        this.cache.put(key, cacheEntry);
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.putAll(map, this.defaultLifetime);
    }

    @Override
    public void putAll(Map<K, V> map, long lifetime) {
        long expirationTime = Util.getTime() + lifetime;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CacheEntry<V> cacheEntry = new CacheEntry<V>(entry.getValue(), expirationTime);
            this.cache.put(entry.getKey(), cacheEntry);
        }
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    public String toString() {
        ConcurrentMap cacheMap = this.cache.asMap();
        String result = "\nContents of Entire Cache\n\n";
        for (Map.Entry entry : cacheMap.entrySet()) {
            result = String.valueOf(result) + "Key: " + entry.getKey() + "\n";
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            result = cacheEntry == null ? String.valueOf(result) + "CacheEntry is null\n" : String.valueOf(result) + cacheEntry.toString();
            result = String.valueOf(result) + "\n\n";
        }
        result = String.valueOf(result) + "Cache size is: " + this.size() + "\n";
        return result;
    }
}

