/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.clientlibrary;

import com.ibm.storage.clientlibrary.Util;
import java.io.Serializable;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class Encryption {
    private static final String DEFAULT_ALGORITHM = "AES";
    private static final String DEFAULT_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    static SecureRandom randomSecureRandom = new SecureRandom();

    public static <T> T decrypt(SealedObject sealedObject, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_TRANSFORMATION);
            cipher.init(2, (java.security.Key)key.secretKey, new IvParameterSpec(key.iv));
            return Util.uncheckedCast(sealedObject.getObject(cipher));
        }
        catch (Exception e) {
            Util.describeException(e, "Exception in Encryption.decrypt");
            return null;
        }
    }

    public static SealedObject encrypt(Serializable object, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_TRANSFORMATION);
            cipher.init(1, (java.security.Key)key.secretKey, new IvParameterSpec(key.iv));
            return new SealedObject(object, cipher);
        }
        catch (Exception e) {
            Util.describeException(e, "Exception in Encryption.encrypt");
            return null;
        }
    }

    public static Key generateKey() {
        Key key = new Key();
        try {
            key.secretKey = KeyGenerator.getInstance(DEFAULT_ALGORITHM).generateKey();
        }
        catch (Exception e) {
            Util.describeException(e, "Exception in Encryption.generateKey");
            return null;
        }
        byte[] iv = new byte[16];
        randomSecureRandom.nextBytes(iv);
        key.iv = iv;
        return key;
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 78L;
        private byte[] iv;
        private SecretKey secretKey;
    }
}

