<?php
/*
 * © Copyright IBM Corp. 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

/**
 * Base test case class. All test cases should extend this class.
 * 
 * @author Benjamin Jakobus
 */
require 'bootstrap.php';
class SBTBaseTestCase extends PHPUnit_Framework_TestCase 
{
	
	protected $uid;
	protected $testEndpoint;
	
	function tearDown() 
	{
		parent::tearDown();
		dropTables();
	}
	
	function setUp() 
	{
		parent::setUp();
		$this->uid = 1;
		$this->testEndpoint = "sampleEndpoint" . time();
	}
}
