/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.spring.rest;

import com.ibm.javametrics.Javametrics;
import com.ibm.javametrics.JavametricsListener;
import com.ibm.javametrics.analysis.MetricsData;
import com.ibm.javametrics.analysis.MetricsProcessor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/javametrics/api/v1"})
class JavametricsRestController {
    private static boolean initialized = false;
    MetricsProcessor mp = MetricsProcessor.getInstance();

    JavametricsRestController() {
    }

    private void init() {
        initialized = true;
        Javametrics.getInstance().addListener((JavametricsListener)MetricsProcessor.getInstance());
    }

    @RequestMapping(produces={"application/json"}, path={"/collections"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCollections() {
        Integer[] contextIds = this.mp.getContextIds();
        StringBuilder sb = new StringBuilder("{\"collectionUris\":[");
        boolean comma = false;
        for (Integer contextId : contextIds) {
            if (comma) {
                sb.append(',');
            }
            sb.append("\"collections/");
            sb.append(contextId);
            sb.append('\"');
            comma = true;
        }
        sb.append("]}");
        return new ResponseEntity((Object)sb.toString(), HttpStatus.OK);
    }

    @RequestMapping(produces={"application/json"}, path={"/collections"}, method={RequestMethod.POST})
    public ResponseEntity<?> createCollection() {
        if (!initialized) {
            this.init();
        }
        if (this.mp.getContextIds().length > 9) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        int contextId = this.mp.addContext();
        UriComponents uriComponents = UriComponentsBuilder.fromPath((String)"collections/{id}").buildAndExpand(new Object[]{contextId});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        String json = new String("{\"uri\":\"" + uriComponents.getPath() + "\"}");
        return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(produces={"application/json"}, path={"/collections/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCollection(@PathVariable(value="id") int id) {
        MetricsData metrics = this.mp.getMetricsData(id);
        if (metrics == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)metrics.toJson(id), HttpStatus.OK);
    }

    @RequestMapping(produces={"application/json"}, path={"/collections/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<?> resetCollection(@PathVariable(value="id") int id) {
        if (!this.mp.resetMetricsData(id)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(produces={"application/json"}, path={"/collections/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteCollection(@PathVariable(value="id") int id) {
        if (!this.mp.removeContext(id)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(produces={"application/json"}, path={"/environment"}, method={RequestMethod.GET})
    public ResponseEntity<?> getEnvironment() {
        return new ResponseEntity((Object)("{\"environment\":" + this.mp.getEnvironment() + "}"), HttpStatus.OK);
    }
}

