/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.spring;

import com.ibm.javametrics.web.DataHandler;
import com.ibm.javametrics.web.Emitter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class JavametricsSpringSocketHandler
extends TextWebSocketHandler
implements Emitter {
    private Set<WebSocketSession> openSessions = new HashSet<WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.openSessions.add(session);
        this.emit("{\"topic\": \"title\", \"payload\": {\"title\":\"Application Metrics for Java\", \"docs\": \"http://github.com/RuntimeTools/javametrics\"}}");
        DataHandler.registerEmitter(this);
    }

    @Override
    public void emit(String message) {
        for (WebSocketSession webSocketSession : this.openSessions) {
            try {
                webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

