/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.spring;

import com.ibm.javametrics.Javametrics;
import com.ibm.javametrics.instrument.HttpData;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JavametricsHTTPDataCollector
extends OncePerRequestFilter {
    private static final String HTTP_TOPIC = "http";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        long duration = System.currentTimeMillis() - startTime;
        HttpData data = new HttpData();
        data.setRequestTime(startTime);
        data.setUrl(request.getRequestURL().toString());
        data.setMethod(request.getMethod());
        data.setContentType(response.getContentType());
        for (String headerName : response.getHeaderNames()) {
            for (String header : response.getHeaders(headerName)) {
                data.addHeader(headerName, header);
            }
        }
        Enumeration reqHeaders = request.getHeaderNames();
        if (reqHeaders != null) {
            while (reqHeaders.hasMoreElements()) {
                String headerName;
                headerName = (String)reqHeaders.nextElement();
                String header = request.getHeader(headerName);
                if (header == null) continue;
                data.addRequestHeader(headerName, header);
            }
        }
        data.setDuration(duration);
        Javametrics.getInstance().sendJSON(HTTP_TOPIC, data.toJsonString());
    }
}

