/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.prometheus;

import com.ibm.javametrics.Javametrics;
import com.ibm.javametrics.JavametricsListener;
import com.ibm.javametrics.client.ApiDataListener;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import io.prometheus.client.hotspot.DefaultExports;
import java.net.MalformedURLException;
import java.net.URL;
import javax.json.JsonObject;

public class Metrics {
    private Gauge os_cpu_used_ratio = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("os_cpu_used_ratio")).help("The ratio of the systems CPU that is currently used (values are 0-1)")).register();
    private Gauge process_cpu_used_ratio = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("process_cpu_used_ratio")).help("The ratio of the process CPU that is currently used (values are 0-1)")).register();
    private Summary http_request_duration_microseconds = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).name("http_request_duration_microseconds")).help("The HTTP request latencies in microseconds.")).labelNames(new String[]{"handler"})).register();
    private Counter http_requests_total = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(new String[]{"code", "handler", "method"})).name("http_requests_total")).help("Total number of HTTP requests made.")).register();
    private ApiDataListener listener = new /* Unavailable Anonymous Inner Class!! */;

    public Metrics() {
        DefaultExports.initialize();
        Javametrics.getInstance().addListener((JavametricsListener)this.listener);
    }

    public void deRegister() {
        Javametrics.getInstance().removeListener((JavametricsListener)this.listener);
    }

    private void handleHttpTopic(JsonObject jsonObject) {
        String urlStr = jsonObject.getJsonString("url").getString();
        String method = jsonObject.getJsonString("method").getString();
        String status = jsonObject.getJsonNumber("status").toString();
        long duration = jsonObject.getJsonNumber("duration").longValue();
        duration *= 1000L;
        try {
            URL url = new URL(urlStr);
            String handler = url.getPath();
            ((Counter.Child)this.http_requests_total.labels(new String[]{status, handler, method})).inc();
            ((Summary.Child)this.http_request_duration_microseconds.labels(new String[]{handler})).observe((double)duration);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static /* synthetic */ void access$000(Metrics x0, JsonObject x1) {
        x0.handleHttpTopic(x1);
    }

    static /* synthetic */ Gauge access$100(Metrics x0) {
        return x0.os_cpu_used_ratio;
    }

    static /* synthetic */ Gauge access$200(Metrics x0) {
        return x0.process_cpu_used_ratio;
    }
}

