# Contributing to graphmetrics

We welcome contributions, but request you follow these guidelines.

 - [Raising bug reports and feature requests](#raising-bug-reports-and-feature-requests)
 - [Pull requests](#pull-requests)
   - [Coding standards](#coding-standards)
   - [IBM Contributor License Agreement](#ibm-contributor-license-agreement)


## Raising bug reports and feature requests

Please raise any bug reports and feature requests on the project's GitHub [issue tracker](https://github.com/runtimetools/graphmetrics/issues).
Be sure to search the list of open and closed issues to see if your problem or request has already been raised.

A good bug report is one that make it easy for us to understand what you were trying to do and what went wrong. Provide as much context as possible so we can try to recreate the issue.

## Pull requests

In order for us to accept pull requests from a new contributor, the contributor must indicate that they accept and agree to be bound by the terms of the IBM Contributor License Agreement below. Please do this by adding your name to the [AUTHORS file](https://github.com/runtimetools/graphmetrics/blob/master/AUTHORS.md)
in your first pull request.

If you want to raise a pull-request for a bug fix or a new feature, we recommend that you raise a [GitHub issue](https://github.com/runtimetools/graphmetrics/issues) to discuss it first.

### Coding standards

Please ensure you follow the coding standards used through-out the existing code base. All source code files include the Apache v2.0 license header.

### IBM Contributor License Agreement
Version 1.0.1 - January 25th, 2017

In order for You (as defined below) to make intellectual property Contributions (as defined below) now or in the future to IBM GitHub repositories, You must agree to this Contributor License Agreement ("CLA"). Please read this CLA carefully before accepting its terms. By accepting the CLA, You are agreeing to be bound by its terms. If You submit a Pull Request against an IBM repository on GitHub You must include in the Pull Request a statement of Your acceptance of this CLA.
As used in this CLA: (i) "You" (or "Your") shall mean the entity that is making this Agreement with IBM; (ii)"Contribution" shall mean any original work of authorship, including any modifications or additions to an existing work, that is submitted by You to IBM for inclusion in, or documentation of, any of the IBM GitHub repositories; (iii) "Submit" (or "Submitted") means any form of communication sent to IBM (e.g. the content You post in a GitHub Issue or submit as part of a GitHub Pull Request).

This agreement applies to all Contributions You Submit.

- You will only Submit Contributions where You have authored 100% of the content.

- You will only Submit Contributions to which You have the necessary rights. This means that if You are employed You have received the necessary permissions from Your employer to make the Contributions.

- Whatever content You Contribute will be provided under the Apache v2.0 license. You can read a copy of the Apache v2.0 License at http://www.apache.org/licenses/LICENSE-2.0.  Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.

- You understand and agree that the Project and Your contributions are public, and that a record of the contribution (including all personal information You submit with it, including Your sign-off) is maintained indefinitely and may be redistributed consistent with the license(s) involved.

- You understand that the decision to include Your Contribution is entirely that of the Project and this agreement does not guarantee that the Contribution will be included in the Project.

- You are not expected to provide support for Your Contribution. However you may provide support for free, for a fee or not at all. You provide Your Contribution on an "AS IS" BASIS as stated in the License.

You will promptly notify the Project if You become aware of any facts or circumstances that would make these commitments inaccurate in any way. To do so, please an issue on the project's GitHub [issue tracker](https://github.com/runtimetools/graphmetrics/issues).
If You think the Project could make use of content which You did not author, please talk to a committer on the Project. If they like Your idea, they will know the process to get it included.
