/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.javametrics.web;

import com.ibm.javametrics.Javametrics;
import com.ibm.javametrics.JavametricsListener;
import com.ibm.javametrics.client.ApiDataListener;
import com.ibm.javametrics.client.HttpDataAggregator;
import com.ibm.javametrics.web.Emitter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataHandler
extends ApiDataListener {
    private static DataHandler instance = null;
    private Set<Emitter> emitters = new HashSet();
    private HttpDataAggregator aggregateHttpData = new HttpDataAggregator();

    private static DataHandler getInstance() {
        if (instance == null) {
            instance = new DataHandler();
        }
        return instance;
    }

    protected DataHandler() {
    }

    public void addEmitter(Emitter emitter) {
        this.emitters.add(emitter);
        Javametrics.getInstance().addListener((JavametricsListener)this);
    }

    public static void registerEmitter(Emitter emitter) {
        DataHandler.getInstance().addEmitter(emitter);
    }

    public void removeEmitter(Emitter emitter) {
        this.emitters.remove(emitter);
        if (this.emitters.isEmpty()) {
            Javametrics.getInstance().removeListener((JavametricsListener)this);
        }
    }

    public static void deregisterEmitter(Emitter emitter) {
        DataHandler.getInstance().removeEmitter(emitter);
    }

    public void emit(String message) {
        this.emitters.forEach(emitter -> emitter.emit(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processData(List<String> jsonData) {
        for (String jsonStr : jsonData) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonStr));
            try {
                JsonObject jsonObject = jsonReader.readObject();
                String topicName = jsonObject.getString("topic", null);
                if (topicName == null) continue;
                if (topicName.equals("http")) {
                    JsonObject payload = jsonObject.getJsonObject("payload");
                    long requestTime = payload.getJsonNumber("time").longValue();
                    long requestDuration = payload.getJsonNumber("duration").longValue();
                    String requestUrl = payload.getString("url", "");
                    String requestMethod = payload.getString("method", "");
                    HttpDataAggregator httpDataAggregator = this.aggregateHttpData;
                    synchronized (httpDataAggregator) {
                        this.aggregateHttpData.aggregate(requestTime, requestDuration, requestUrl, requestMethod);
                        continue;
                    }
                }
                this.emit(jsonObject.toString());
            }
            catch (JsonException je) {
                je.printStackTrace();
            }
        }
        this.emitHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitHttp() {
        StringBuilder httpUrlData;
        StringBuilder httpData;
        HttpDataAggregator httpDataAggregator = this.aggregateHttpData;
        synchronized (httpDataAggregator) {
            long time = this.aggregateHttpData.getTime();
            long total = this.aggregateHttpData.getTotalHits();
            long longest = this.aggregateHttpData.getLongest();
            double average = this.aggregateHttpData.getAverage();
            String url = this.aggregateHttpData.getLongestUrl();
            String method = this.aggregateHttpData.getLongestMethod();
            if (total == 0L) {
                time = System.currentTimeMillis();
            }
            httpData = new StringBuilder("{\"topic\":\"http\",\"payload\":{\"time\":");
            httpData.append(time);
            httpData.append(",\"total\":");
            httpData.append(total);
            httpData.append(",\"longest\":");
            httpData.append(longest);
            httpData.append(",\"average\":");
            httpData.append(average);
            httpData.append(",\"url\":\"");
            httpData.append(url);
            httpData.append("\",\"method\":\"");
            httpData.append(method);
            httpData.append("\"}}");
            httpUrlData = new StringBuilder("{\"topic\":\"httpURLs\",\"payload\":[");
            Iterator it = this.aggregateHttpData.getUrlData().iterator();
            while (it.hasNext()) {
                HttpDataAggregator.HttpUrlData hud = (HttpDataAggregator.HttpUrlData)it.next();
                httpUrlData.append("{\"url\":\"");
                httpUrlData.append(hud.getMethod());
                httpUrlData.append(" ");
                httpUrlData.append(hud.getUrl());
                httpUrlData.append("\",\"hits\":");
                httpUrlData.append(hud.getHits());
                httpUrlData.append(",\"longestResponseTime\":");
                httpUrlData.append(hud.getLongestResponseTime());
                httpUrlData.append(",\"averageResponseTime\":");
                httpUrlData.append(hud.getAverageResponseTime());
                httpUrlData.append('}');
                if (!it.hasNext()) continue;
                httpUrlData.append(',');
            }
            httpUrlData.append("]}");
            this.aggregateHttpData.resetSummaryData();
        }
        this.emit(httpData.toString());
        this.emit(httpUrlData.toString());
    }
}

